/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.processors;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.metrics.collectors.DuccGarbageStatsCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessCpuUsageCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessMajorFaultCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessResidentMemoryCollector;
import org.apache.uima.ducc.agent.processors.BaseProcessor;
import org.apache.uima.ducc.agent.processors.ProcessMetricsProcessor;
import org.apache.uima.ducc.common.agent.metrics.cpu.ProcessCpuUsage;
import org.apache.uima.ducc.common.agent.metrics.memory.ProcessResidentMemory;
import org.apache.uima.ducc.common.agent.metrics.swap.DuccProcessSwapSpaceUsage;
import org.apache.uima.ducc.common.agent.metrics.swap.ProcessMemoryPageLoadUsage;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class LinuxProcessMetricsProcessor
extends BaseProcessor
implements ProcessMetricsProcessor {
    private RandomAccessFile statmFile;
    private RandomAccessFile processStatFile;
    private long totalCpuInitUsage = 0L;
    private boolean initializing = true;
    private final ExecutorService pool;
    private IDuccProcess process;
    private DuccGarbageStatsCollector gcStatsCollector;
    private int blockSize = 4096;
    private DuccLogger logger;
    private ManagedProcess managedProcess;
    private NodeAgent agent;
    private int fudgeFactor = 5;
    private volatile boolean closed = true;
    private long clockAtStartOfRun = 0L;
    private long percentCPU = 0L;

    public LinuxProcessMetricsProcessor(DuccLogger logger, IDuccProcess process, NodeAgent agent, String statmFilePath, String nodeStatFilePath, String processStatFilePath, ManagedProcess managedProcess) throws FileNotFoundException {
        this.logger = logger;
        this.statmFile = new RandomAccessFile(statmFilePath, "r");
        this.processStatFile = new RandomAccessFile(processStatFilePath, "r");
        this.managedProcess = managedProcess;
        this.agent = agent;
        this.pool = Executors.newCachedThreadPool();
        this.process = process;
        this.gcStatsCollector = new DuccGarbageStatsCollector(logger, process);
        managedProcess.setMetricsProcessor(this);
        this.blockSize = agent.getOSPageSize();
        if (System.getProperty("ducc.agent.share.size.fudge.factor") != null) {
            try {
                this.fudgeFactor = Integer.parseInt(System.getProperty("ducc.agent.share.size.fudge.factor"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.closed = false;
    }

    @Override
    public void stop() {
        try {
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error("LinuxProcessMetricsProcessor.stop()", null, (Throwable)e, new Object[0]);
        }
    }

    public void close() {
        this.closed = true;
        try {
            if (this.statmFile != null && this.statmFile.getFD().valid()) {
                this.statmFile.close();
            }
            if (this.processStatFile != null && this.processStatFile.getFD().valid()) {
                this.processStatFile.close();
            }
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean collectStats(IProcessState.ProcessState state) {
        return !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Stopped) && !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Killed) && !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Failed) && !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Stopping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange e) {
        if (this.closed) {
            return;
        }
        if (!this.collectStats(this.process.getProcessState())) {
            return;
        }
        if (this.process.getProcessState().equals((Object)IProcessState.ProcessState.Initializing) || this.process.getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
            try {
                String[] cgroupPids;
                int currentCpuUsage;
                long totalRss;
                long totalCpuUsage;
                long totalFaults;
                long totalSwapUsage;
                block45: {
                    totalSwapUsage = 0L;
                    totalFaults = 0L;
                    totalCpuUsage = 0L;
                    totalRss = 0L;
                    currentCpuUsage = 0;
                    Future<ProcessMemoryPageLoadUsage> processMajorFaultUsage = null;
                    Future<ProcessCpuUsage> processCpuUsage = null;
                    cgroupPids = new String[]{};
                    try {
                        String swapUsageScript = System.getProperty("ducc.agent.swap.usage.script");
                        if (this.agent.useCgroups) {
                            String containerId = this.agent.cgroupsManager.getContainerId(this.managedProcess);
                            for (String pid : cgroupPids = this.agent.cgroupsManager.getPidsInCgroup(containerId)) {
                                if (swapUsageScript != null) {
                                    DuccProcessSwapSpaceUsage processSwapSpaceUsage = new DuccProcessSwapSpaceUsage(pid, this.managedProcess.getOwner(), swapUsageScript, this.logger);
                                    totalSwapUsage += processSwapSpaceUsage.getSwapUsage();
                                }
                                ProcessMajorFaultCollector processMajorFaultUsageCollector = new ProcessMajorFaultCollector(this.logger, pid);
                                if (!this.collectStats(this.process.getProcessState())) {
                                    return;
                                }
                                processMajorFaultUsage = this.pool.submit(processMajorFaultUsageCollector);
                                totalFaults += processMajorFaultUsage.get().getMajorFaults();
                                try (RandomAccessFile raf = null;){
                                    raf = new RandomAccessFile("/proc/" + pid + "/stat", "r");
                                    ProcessCpuUsageCollector processCpuUsageCollector = new ProcessCpuUsageCollector(this.logger, pid, raf, 42, 0);
                                    if (!this.collectStats(this.process.getProcessState())) {
                                        return;
                                    }
                                    processCpuUsage = this.pool.submit(processCpuUsageCollector);
                                    totalCpuUsage += processCpuUsage.get().getTotalJiffies() / (long)this.agent.cpuClockRate;
                                }
                                currentCpuUsage += this.collectProcessCurrentCPU(pid);
                                RandomAccessFile rStatmFile = null;
                                try {
                                    rStatmFile = new RandomAccessFile("/proc/" + pid + "/statm", "r");
                                }
                                catch (FileNotFoundException fnfe) {
                                    this.logger.info("LinuxProcessMetricsProcessor.process", null, new Object[]{"Statm File:/proc/" + pid + "/statm *Not Found*. Process must have already exited"});
                                    return;
                                }
                                ProcessResidentMemoryCollector collector = new ProcessResidentMemoryCollector(rStatmFile, 2, 0);
                                if (!this.collectStats(this.process.getProcessState())) {
                                    return;
                                }
                                Future<ProcessResidentMemory> prm = this.pool.submit(collector);
                                totalRss += prm.get().get();
                                rStatmFile.close();
                            }
                            break block45;
                        }
                        if (swapUsageScript != null) {
                            DuccProcessSwapSpaceUsage processSwapSpaceUsage = new DuccProcessSwapSpaceUsage(this.process.getPID(), this.managedProcess.getOwner(), swapUsageScript, this.logger);
                            totalSwapUsage = processSwapSpaceUsage.getSwapUsage();
                        }
                        ProcessMajorFaultCollector processMajorFaultUsageCollector = new ProcessMajorFaultCollector(this.logger, this.process.getPID());
                        if (!this.collectStats(this.process.getProcessState())) {
                            return;
                        }
                        processMajorFaultUsage = this.pool.submit(processMajorFaultUsageCollector);
                        totalFaults = processMajorFaultUsage.get().getMajorFaults();
                        ProcessCpuUsageCollector processCpuUsageCollector = new ProcessCpuUsageCollector(this.logger, this.process.getPID(), this.processStatFile, 42, 0);
                        if (!this.collectStats(this.process.getProcessState())) {
                            return;
                        }
                        processCpuUsage = this.pool.submit(processCpuUsageCollector);
                        totalCpuUsage = processCpuUsage.get().getTotalJiffies() / (long)this.agent.cpuClockRate;
                        currentCpuUsage = this.collectProcessCurrentCPU(this.process.getPID());
                        ProcessResidentMemoryCollector collector = new ProcessResidentMemoryCollector(this.statmFile, 2, 0);
                        if (!this.collectStats(this.process.getProcessState())) {
                            return;
                        }
                        Future<ProcessResidentMemory> prm = this.pool.submit(collector);
                        totalRss = prm.get().get();
                    }
                    catch (Exception exc) {
                        if (!this.collectStats(this.process.getProcessState())) {
                            return;
                        }
                        this.logger.error("LinuxProcessMetricsProcessor.process", null, (Throwable)exc, new Object[0]);
                    }
                }
                if (this.managedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
                    if (this.agent.cpuClockRate > 0) {
                        long timeSinceRunningInSeconds;
                        if (this.initializing) {
                            this.initializing = false;
                            this.totalCpuInitUsage = totalCpuUsage;
                            this.clockAtStartOfRun = System.currentTimeMillis();
                        }
                        if ((timeSinceRunningInSeconds = (System.currentTimeMillis() - this.clockAtStartOfRun) / 1000L) > 0L) {
                            this.percentCPU = 100L * (totalCpuUsage - this.totalCpuInitUsage) / timeSinceRunningInSeconds;
                        }
                        this.process.setCpuTime(this.percentCPU);
                    } else {
                        this.process.setCpuTime(0L);
                        this.logger.info("process", null, new Object[]{"Agent is unable to determine Node's clock rate. Defaulting CPU Time to 0 For Process with PID:" + this.process.getPID()});
                    }
                } else if (this.managedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Initializing)) {
                    this.process.setCpuTime(0L);
                } else {
                    this.process.setCpuTime(0L);
                }
                this.process.setCurrentCPU((long)currentCpuUsage);
                this.logger.info("process", null, new Object[]{"----------- PID:" + this.process.getPID() + " Average CPU Time:" + this.percentCPU + "% Current CPU Time:" + this.process.getCurrentCPU()});
                this.process.setMajorFaults(totalFaults);
                long st = System.currentTimeMillis();
                long processSwapUsage = totalSwapUsage * 1024L;
                this.process.setSwapUsage(processSwapUsage);
                this.logger.info("process", null, new Object[]{"----------- PID:" + this.process.getPID() + " Major Faults:" + totalFaults + " Process Swap Usage:" + processSwapUsage + " Max Swap Usage Allowed:" + this.managedProcess.getMaxSwapThreshold() + " Time to Collect Swap Usage:" + (System.currentTimeMillis() - st)});
                if (!(processSwapUsage > 0L && processSwapUsage > this.managedProcess.getMaxSwapThreshold() || this.agent.useCgroups || this.fudgeFactor <= -1 || this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge() <= 0L)) {
                    long rss = totalRss * (long)(this.blockSize / 1024) / 1024L;
                    this.logger.trace("process", null, new Object[]{"*** Process with PID:" + this.managedProcess.getPid() + " Assigned Memory (MB): " + this.managedProcess.getProcessMemoryAssignment() + " MBs. Current RSS (MB):" + rss});
                    if (rss > this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge()) {
                        this.logger.error("process", null, new Object[]{"\n\n********************************************************\n\tProcess with PID:" + this.managedProcess.getPid() + " Exceeded its max memory assignment (including a fudge factor) of " + this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge() + " MBs. This Process Resident Memory Size: " + rss + " MBs .Killing process ...\n********************************************************\n\n"});
                        try {
                            this.managedProcess.kill();
                            this.process.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.ExceededShareSize.toString());
                            this.agent.stopProcess(this.process);
                            if (this.agent.useCgroups) {
                                for (String pid : cgroupPids) {
                                    if (pid.equals(this.managedProcess.getDuccProcess().getPID())) continue;
                                    this.killChildProcess(pid, "-15");
                                }
                            }
                        }
                        catch (Exception ee) {
                            if (!this.collectStats(this.process.getProcessState())) {
                                return;
                            }
                            this.logger.error("process", null, (Throwable)ee, new Object[0]);
                        }
                        return;
                    }
                }
                this.process.setResidentMemory(totalRss * (long)this.blockSize);
                if (!this.process.getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop)) {
                    ProcessGarbageCollectionStats gcStats = this.gcStatsCollector.collect();
                    this.process.setGarbageCollectionStats(gcStats);
                    this.logger.info("process", null, new Object[]{"PID:" + this.process.getPID() + " Total GC Collection Count :" + gcStats.getCollectionCount() + " Total GC Collection Time :" + gcStats.getCollectionTime()});
                }
            }
            catch (Exception ex) {
                if (!this.collectStats(this.process.getProcessState())) {
                    return;
                }
                this.logger.error("process", null, (Throwable)ex, new Object[0]);
                ex.printStackTrace();
            }
        }
    }

    private int collectProcessCurrentCPU(String pid) throws Exception {
        InputStream stream = null;
        BufferedReader reader = null;
        String cpuTime = "0";
        int cpuint = 0;
        if (this.process != null && (this.process.getProcessState().equals((Object)IProcessState.ProcessState.Running) || this.process.getProcessState().equals((Object)IProcessState.ProcessState.Initializing))) {
            String line;
            ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", "top -b -n 1 -p " + pid + " | tail -n 2 | head -n 1 | awk '{print $9}'");
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            stream = proc.getInputStream();
            reader = new BufferedReader(new InputStreamReader(stream));
            String regex = "\\s+";
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(regex);
                if (tokens.length <= 0) continue;
                this.logger.info("collectProcessCurrentCPU", null, new Object[]{" PID:" + pid + " " + line + " == CPUTIME:" + tokens[0]});
                cpuTime = tokens[0];
            }
            if (cpuTime.indexOf(".") > -1) {
                cpuTime = cpuTime.substring(0, cpuTime.indexOf("."));
            }
            stream.close();
            proc.waitFor();
            try {
                cpuint = Integer.valueOf(cpuTime);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return cpuint;
    }

    private void killChildProcess(String pid, final String signal) {
        new Thread(){

            @Override
            public void run() {
                String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
                try {
                    String[] killCmd = null;
                    String useSpawn = System.getProperty("ducc.agent.launcher.use.ducc_spawn");
                    killCmd = useSpawn != null && useSpawn.toLowerCase().equals("true") ? new String[]{c_launcher_path, "-u", LinuxProcessMetricsProcessor.this.managedProcess.getOwner(), "--", "/bin/kill", signal, LinuxProcessMetricsProcessor.this.managedProcess.getDuccProcess().getPID()} : new String[]{"/bin/kill", "-15", LinuxProcessMetricsProcessor.this.managedProcess.getDuccProcess().getPID()};
                    ProcessBuilder pb = new ProcessBuilder(killCmd);
                    Process p = pb.start();
                    p.wait(60000L);
                    p.destroy();
                }
                catch (Exception e) {
                    LinuxProcessMetricsProcessor.this.logger.error("killChildProcess", LinuxProcessMetricsProcessor.this.managedProcess.getWorkDuccId(), (Throwable)e, new Object[0]);
                }
            }
        }.start();
    }
}

