/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.Callable;
import org.apache.uima.ducc.common.node.metrics.NodeCpuInfo;

public class NodeCpuCollector
implements Callable<NodeCpuInfo> {
    @Override
    public NodeCpuInfo call() throws Exception {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        return new NodeCpuInfo(osBean.getAvailableProcessors(), String.valueOf(this.getCPULoad()));
    }

    private double getCPULoad() throws Exception {
        double cpu = 0.0;
        InputStreamReader in = null;
        String[] command = new String[]{"/bin/sh", "-c", "/bin/grep 'cpu' /proc/stat | /bin/awk '{usage=($2+$4)*100/($2+$4+$5)} END {print usage}'"};
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(command);
            pb.redirectErrorStream(true);
            Process swapCollectorProcess = pb.start();
            in = new InputStreamReader(swapCollectorProcess.getInputStream());
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                try {
                    cpu = Double.parseDouble(line.trim());
                }
                catch (NumberFormatException e) {
                    cpu = 0.0;
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return cpu;
    }
}

