/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;

public class CGroupsManager {
    private DuccLogger agentLogger = null;
    private Set<String> containerIds = new LinkedHashSet<String>();
    private String cgroupBaseDir = "";
    private String cgroupUtilsDir = null;
    private String cgroupSubsystems = "";
    private long maxTimeToWaitForProcessToStop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CGroupsManager cgMgr = new CGroupsManager("/usr/bin", "/cgroup/ducc", "memory", null, 10000L);
            System.out.println("Cgroups Installed:" + cgMgr.cgroupExists("/cgroup/ducc"));
            Set<String> containers = cgMgr.collectExistingContainers();
            for (String containerId : containers) {
                System.out.println("Existing CGroup Container ID:" + containerId);
            }
            cgMgr.createContainer(args[0], args[2], true);
            cgMgr.setContainerMaxMemoryLimit(args[0], args[2], true, Long.parseLong(args[1]));
            CGroupsManager cGroupsManager = cgMgr;
            synchronized (cGroupsManager) {
                cgMgr.wait(60000L);
            }
            cgMgr.destroyContainer(args[0], args[2], NodeAgent.SIGKILL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCGroupsUtilsDir() {
        return this.cgroupUtilsDir;
    }

    public CGroupsManager(String cgroupUtilsDir, String cgroupBaseDir, String cgroupSubsystems, DuccLogger agentLogger, long maxTimeToWaitForProcessToStop) {
        this.cgroupUtilsDir = cgroupUtilsDir;
        this.cgroupBaseDir = cgroupBaseDir;
        this.cgroupSubsystems = cgroupSubsystems;
        this.agentLogger = agentLogger;
        this.maxTimeToWaitForProcessToStop = maxTimeToWaitForProcessToStop;
    }

    public String[] getPidsInCgroup(String cgroupName) throws Exception {
        File f = new File(this.cgroupBaseDir + "/" + cgroupName + "/cgroup.procs");
        return this.readPids(f);
    }

    private String[] readPids(File f) throws Exception {
        String line;
        ArrayList<String> pids = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            pids.add(line.trim());
        }
        br.close();
        return pids.toArray(new String[pids.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupOnStartup() throws Exception {
        String[] files;
        Set<NodeProcessInfo> processes = this.getProcessesOnNode();
        Pattern p = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+))");
        File cgroupsFolder = new File(this.cgroupBaseDir);
        for (String cgroupFolder : files = cgroupsFolder.list()) {
            Matcher m = p.matcher(cgroupFolder);
            if (!m.find()) continue;
            try {
                File f = new File(this.cgroupBaseDir + "/" + cgroupFolder + "/cgroup.procs");
                String[] pids = this.readPids(f);
                int zombieCount = 0;
                if (pids != null && pids.length > 0) {
                    for (String pid : pids) {
                        for (NodeProcessInfo proc : processes) {
                            if (proc.isZombie()) {
                                ++zombieCount;
                                continue;
                            }
                            if (!proc.getPid().equals(pid)) continue;
                            this.kill(proc.getUserid(), proc.getPid(), NodeAgent.SIGKILL);
                        }
                    }
                    long logCount = 0L;
                    while ((pids = this.readPids(f)) != null && pids.length != 0 && zombieCount != pids.length) {
                        try {
                            CGroupsManager i$ = this;
                            synchronized (i$) {
                                if (logCount % 10000L == 0L) {
                                    this.agentLogger.info("cleanupOnStartup", null, new Object[]{"--- CGroup:" + cgroupFolder + " procs file still showing processes running. Wait until CGroups updates acccounting"});
                                }
                                ++logCount;
                                this.wait(200L);
                            }
                        }
                        catch (InterruptedException ee) {
                            // empty catch block
                            break;
                        }
                    }
                }
                if (zombieCount == 0) {
                    this.destroyContainer(cgroupFolder, "ducc", NodeAgent.SIGTERM);
                    this.agentLogger.info("cleanupOnStartup", null, new Object[]{"--- Agent Removed Empty CGroup:" + cgroupFolder});
                    continue;
                }
                this.agentLogger.info("cleanupOnStartup", null, new Object[]{"CGroup " + cgroupFolder + " Contains Zombie Processing. Not Removing the Container"});
            }
            catch (Exception e) {
                this.agentLogger.error("cleanupOnStartup", null, (Throwable)e, new Object[0]);
            }
        }
    }

    public boolean isPidInCGroup(String pid) throws Exception {
        String[] pids;
        for (String p : pids = this.getAllCGroupPids()) {
            if (!p.equals(pid)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllCGroupPids() throws Exception {
        String[] files;
        ArrayList<String> cgroupPids = new ArrayList<String>();
        Pattern p = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+))");
        File cgroupsFolder = new File(this.cgroupBaseDir);
        for (String cgroupFolder : files = cgroupsFolder.list()) {
            Matcher m = p.matcher(cgroupFolder);
            if (!m.find()) continue;
            try {
                String[] pids;
                File f = new File(this.cgroupBaseDir + "/" + cgroupFolder + "/cgroup.procs");
                for (String pid : pids = this.readPids(f)) {
                    cgroupPids.add(pid);
                }
            }
            catch (Exception e) {
                this.agentLogger.error("getAllCGroupPids", null, (Throwable)e, new Object[0]);
                throw e;
            }
        }
        String[] pids = new String[cgroupPids.size()];
        return cgroupPids.toArray(pids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(String user, String pid, int signal) {
        String methodName = "kill";
        InputStream is = null;
        BufferedReader reader = null;
        try {
            String arg;
            String cmdLine;
            String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
            boolean useDuccling = false;
            if (Utils.isWindows()) {
                cmdLine = "taskkill";
                arg = "/PID";
            } else {
                String useSpawn = System.getProperty("ducc.agent.launcher.use.ducc_spawn");
                if (useSpawn != null && useSpawn.toLowerCase().equals("true")) {
                    useDuccling = true;
                }
                cmdLine = "/bin/kill";
                arg = "-" + signal;
            }
            String[] duccling_nolog = useDuccling ? new String[]{c_launcher_path, "-u", user, "--", cmdLine, arg, pid} : new String[]{cmdLine, arg, pid};
            ProcessBuilder pb = new ProcessBuilder(duccling_nolog);
            pb.redirectErrorStream(true);
            Process killedProcess = pb.start();
            is = killedProcess.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is));
            while (reader.readLine() != null) {
            }
            is.close();
            killedProcess.waitFor();
            StringBuffer sb = new StringBuffer();
            for (String part : duccling_nolog) {
                sb.append(part).append(" ");
            }
            if (this.agentLogger == null) {
                System.out.println("--------- Killed Process:" + pid + " Owned by:" + user + " Command:" + sb.toString());
            } else {
                this.agentLogger.info("kill", null, new Object[]{"--------- Killed CGroup Process:" + pid + " Owned by:" + user + " Command:" + sb.toString()});
            }
        }
        catch (Exception e) {
            this.agentLogger.error("kill", null, (Throwable)e, new Object[0]);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String getContainerId(ManagedProcess managedProcess) {
        String containerId = managedProcess.getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Service) ? String.valueOf(managedProcess.getDuccProcess().getCGroup().getId()) : managedProcess.getWorkDuccId().getFriendly() + "." + managedProcess.getDuccProcess().getCGroup().getId();
        return containerId;
    }

    public boolean createContainer(String containerId, String userId, boolean useDuccSpawn) throws Exception {
        try {
            this.agentLogger.info("createContainer", null, new Object[]{"Creating CGroup Container:" + containerId});
            String[] command = new String[]{this.cgroupUtilsDir + "/cgcreate", "-t", "ducc", "-a", "ducc", "-g", this.cgroupSubsystems + ":ducc/" + containerId};
            int retCode = this.launchCommand(command, useDuccSpawn, "ducc", containerId);
            if (retCode == 0 || retCode == 96) {
                this.containerIds.add(containerId);
                this.agentLogger.info("createContainer", null, new Object[]{">>>>SUCCESS - Created CGroup Container:" + containerId});
                return true;
            }
            this.agentLogger.info("createContainer", null, new Object[]{">>>>FAILURE - Unable To Create CGroup Container:" + containerId});
            return false;
        }
        catch (Exception e) {
            this.agentLogger.error("createContainer", null, new Object[]{">>>>FAILURE - Unable To Create CGroup Container:" + containerId, e});
            return false;
        }
    }

    public boolean setContainerMaxMemoryLimit(String containerId, String userId, boolean useDuccSpawn, long containerMaxSize) throws Exception {
        try {
            String[] command = new String[]{this.cgroupUtilsDir + "/cgset", "-r", "memory.limit_in_bytes=" + containerMaxSize, "ducc/" + containerId};
            int retCode = this.launchCommand(command, useDuccSpawn, "ducc", containerId);
            if (retCode == 0) {
                this.agentLogger.info("setContainerMaxMemoryLimit", null, new Object[]{">>>>SUCCESS - Created CGroup Limit on Container:" + containerId});
                return true;
            }
            this.agentLogger.info("setContainerMaxMemoryLimit", null, new Object[]{">>>>FAILURE - Unable To Create CGroup Container:" + containerId});
            return false;
        }
        catch (Exception e) {
            this.agentLogger.error("setContainerMaxMemoryLimit", null, new Object[]{">>>>FAILURE - Unable To Set Limit On CGroup Container:" + containerId, e});
            return false;
        }
    }

    public boolean setContainerCpuShares(String containerId, String userId, boolean useDuccSpawn, long containerCpuShares) throws Exception {
        try {
            String[] command = new String[]{this.cgroupUtilsDir + "/cgset", "-r", "cpu.shares=" + containerCpuShares, "ducc/" + containerId};
            int retCode = this.launchCommand(command, useDuccSpawn, "ducc", containerId);
            if (retCode == 0) {
                this.agentLogger.info("setContainerCpuShares", null, new Object[]{">>>>SUCCESS - Created CGroup with CPU Shares=" + containerCpuShares + " on Container:" + containerId});
                return true;
            }
            this.agentLogger.info("setContainerCpuShares", null, new Object[]{">>>>FAILURE - Unable To Create CGroup Container:" + containerId});
            return false;
        }
        catch (Exception e) {
            this.agentLogger.error("setContainerCpuShares", null, new Object[]{">>>>FAILURE - Unable To Set CPU shares On CGroup Container:" + containerId, e});
            return false;
        }
    }

    private int killChildProcesses(String containerId, String userId, int signal) throws Exception {
        int childCount = 0;
        String[] pids = this.getPidsInCgroup(containerId);
        if (pids != null) {
            if (pids.length > 0) {
                childCount = pids.length;
                this.agentLogger.info("killChildProcesses", null, new Object[]{"Found " + pids.length + " child processes still in container:" + containerId + " - killing all"});
            }
            for (String pid : pids) {
                try {
                    this.kill(userId, pid, signal);
                }
                catch (Exception ee) {
                    this.agentLogger.warn("killChildProcesses", null, new Object[]{"Unable to kill child process with PID:" + pid + " from cgroup:" + containerId + "\n" + ee});
                }
            }
        }
        return childCount;
    }

    public boolean destroyContainer(String containerId, String userId, int signal) throws Exception {
        try {
            if (this.cgroupExists(this.cgroupBaseDir + "/" + containerId)) {
                if (signal == NodeAgent.SIGTERM) {
                    this.agentLogger.info("destroyContainer", null, new Object[]{"Destroying Container " + containerId + " Using signal:" + signal + " to kill child processes if any still exist in cgroups container"});
                    int childProcessCount = this.killChildProcesses(containerId, userId, NodeAgent.SIGTERM);
                    if (childProcessCount > 0) {
                        this.agentLogger.info("destroyContainer", null, new Object[]{"Killed " + childProcessCount + "Child Processes with kill -15"});
                        try {
                            this.wait(this.maxTimeToWaitForProcessToStop);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
                this.killChildProcesses(containerId, userId, NodeAgent.SIGKILL);
                String[] command = new String[]{"/bin/rmdir", this.cgroupBaseDir + "/" + containerId};
                int retCode = this.launchCommand(command, false, "ducc", containerId);
                if (retCode == 0) {
                    this.containerIds.remove(containerId);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int launchCommand(String[] command, boolean useDuccSpawn, String userId, String containerId) throws Exception {
        String[] commandLine = null;
        InputStreamReader in = null;
        BufferedReader reader = null;
        try {
            int retCode;
            String line;
            String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
            StringBuffer sb = new StringBuffer();
            if (useDuccSpawn && c_launcher_path != null) {
                commandLine = new String[4 + command.length];
                commandLine[0] = c_launcher_path;
                sb.append(c_launcher_path).append(" ");
                commandLine[1] = "-u";
                sb.append("-u ");
                commandLine[2] = userId;
                sb.append(userId);
                commandLine[3] = "--";
                sb.append(" -- ");
                int j = 0;
                for (int i = 4; i < commandLine.length; ++i) {
                    sb.append(command[j]).append(" ");
                    commandLine[i] = command[j++];
                }
            } else {
                commandLine = command;
                if (command != null) {
                    for (int i = 0; i < command.length; ++i) {
                        sb.append(command[i]).append(" ");
                    }
                }
            }
            this.agentLogger.info("launchCommand", null, new Object[]{"Launching Process - Commandline:" + sb.toString()});
            ProcessBuilder processLauncher = new ProcessBuilder(new String[0]);
            processLauncher.command(commandLine);
            processLauncher.redirectErrorStream();
            Process process = processLauncher.start();
            in = new InputStreamReader(process.getInputStream());
            reader = new BufferedReader(in);
            this.agentLogger.info("launchCommand", null, new Object[]{"Consuming Process Streams"});
            while ((line = reader.readLine()) != null) {
                this.agentLogger.info("launchCommand", null, new Object[]{">>>>" + line});
            }
            this.agentLogger.info("launchCommand", null, new Object[]{"Waiting for Process to Exit"});
            int n = retCode = process.waitFor();
            return n;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            if (commandLine != null) {
                for (String cmdPart : commandLine) {
                    sb.append(cmdPart).append(" ");
                }
            }
            if (this.agentLogger != null) {
                this.agentLogger.error("launchCommand", null, new Object[]{"Unable to Launch Command:" + sb.toString(), e});
            } else {
                System.out.println("CGroupsManager.launchCommand()- Unable to Launch Command:" + sb.toString());
                e.printStackTrace();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exx) {}
            }
        }
        return -1;
    }

    public Set<String> collectExistingContainers() throws Exception {
        File duccCGroupBaseDir = new File(this.cgroupBaseDir);
        if (duccCGroupBaseDir.exists()) {
            File[] existingCGroups;
            for (File cgroup : existingCGroups = duccCGroupBaseDir.listFiles()) {
                if (!cgroup.isDirectory()) continue;
                this.containerIds.add(cgroup.getName());
            }
        }
        return this.containerIds;
    }

    public String getDuccCGroupBaseDir() {
        return this.cgroupBaseDir;
    }

    public String getSubsystems() {
        return this.cgroupSubsystems;
    }

    public boolean cgroupExists(String cgroup) throws Exception {
        File duccCGroupBaseDir = new File(cgroup);
        return duccCGroupBaseDir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NodeProcessInfo> getProcessesOnNode() throws Exception {
        String location = "getProcessesOnNode";
        HashSet<NodeProcessInfo> processList = new HashSet<NodeProcessInfo>();
        InputStream stream = null;
        try (BufferedReader reader = null;){
            String line;
            ProcessBuilder pb = new ProcessBuilder("ps", "-Ao", "user:12,pid,ppid,args,stat", "--no-heading");
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            stream = proc.getInputStream();
            reader = new BufferedReader(new InputStreamReader(stream));
            String regex = "\\s+";
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(regex);
                String user = tokens[0];
                String pid = tokens[1];
                String ppid = tokens[2];
                String stat = tokens[4];
                if (tokens.length <= 0) continue;
                processList.add(new NodeProcessInfo(pid, ppid, user, stat));
            }
        }
        return processList;
    }

    public class NodeProcessInfo {
        private String pid;
        private String ppid;
        private String userid;
        private String stat;

        NodeProcessInfo(String pid, String ppid, String uid, String stat) {
            this.pid = pid;
            this.ppid = ppid;
            this.userid = uid;
            this.stat = stat;
        }

        public boolean isZombie() {
            return this.stat == "Z";
        }

        public String getPid() {
            return this.pid;
        }

        public String getPpid() {
            return this.ppid;
        }

        public String getUserid() {
            return this.userid;
        }

        public void setUserid(String userid) {
            this.userid = userid;
        }
    }
}

