/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.processors;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.metrics.collectors.NodeCpuCollector;
import org.apache.uima.ducc.agent.metrics.collectors.NodeLoadAverageCollector;
import org.apache.uima.ducc.agent.metrics.collectors.NodeMemInfoCollector;
import org.apache.uima.ducc.agent.metrics.collectors.NodeUsersCollector;
import org.apache.uima.ducc.agent.processors.BaseProcessor;
import org.apache.uima.ducc.agent.processors.NodeMetricsProcessor;
import org.apache.uima.ducc.common.DuccNode;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.agent.metrics.memory.NodeMemory;
import org.apache.uima.ducc.common.node.metrics.NodeCpuInfo;
import org.apache.uima.ducc.common.node.metrics.NodeLoadAverage;
import org.apache.uima.ducc.common.node.metrics.NodeMetrics;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;

public class LinuxNodeMetricsProcessor
extends BaseProcessor
implements NodeMetricsProcessor {
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"Agent");
    public static String[] MeminfoTargetFields = new String[]{"MemTotal:", "MemFree:", "SwapTotal:", "SwapFree:"};
    private NodeAgent agent;
    private final ExecutorService pool;
    private RandomAccessFile memInfoFile;
    private RandomAccessFile loadAvgFile;
    private int swapThreshold = 0;

    public LinuxNodeMetricsProcessor(NodeAgent agent, String memInfoFilePath, String loadAvgFilePath) throws FileNotFoundException {
        this.agent = agent;
        this.pool = Executors.newCachedThreadPool();
        this.memInfoFile = new RandomAccessFile(memInfoFilePath, "r");
        this.loadAvgFile = new RandomAccessFile(loadAvgFilePath, "r");
        if (System.getProperty("ducc.node.min.swap.threshold") != null) {
            try {
                this.swapThreshold = Integer.valueOf(System.getProperty("ducc.node.min.swap.threshold"));
                this.logger.info("ctor", null, new Object[]{"Ducc Node Min Swap Threshold:" + this.swapThreshold});
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        try {
            if (this.memInfoFile != null) {
                this.memInfoFile.close();
            }
            if (this.loadAvgFile != null) {
                this.loadAvgFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process(Exchange e) {
        String methodName = "process";
        try {
            NodeMemInfoCollector memCollector = new NodeMemInfoCollector(MeminfoTargetFields);
            Future<NodeMemory> nmiFuture = this.pool.submit(memCollector);
            NodeLoadAverageCollector loadAvgCollector = new NodeLoadAverageCollector(this.loadAvgFile, 5, 0);
            Future<NodeLoadAverage> loadFuture = this.pool.submit(loadAvgCollector);
            NodeCpuCollector cpuCollector = new NodeCpuCollector();
            Future<NodeCpuInfo> cpuFuture = this.pool.submit(cpuCollector);
            e.getIn().setHeader("node", (Object)this.agent.getIdentity().getName());
            NodeMemory memInfo = nmiFuture.get();
            TreeMap<Object, Object> users = null;
            if (this.agent.receivedDuccState) {
                NodeUsersCollector nodeUsersCollector = new NodeUsersCollector(this.agent, this.logger);
                this.logger.info(methodName, null, new Object[]{"... Agent Collecting User Processes"});
                Future<TreeMap<String, NodeUsersInfo>> nuiFuture = this.pool.submit(nodeUsersCollector);
                users = nuiFuture.get();
            } else {
                users = new TreeMap();
            }
            NodeMetrics nodeMetrics = new NodeMetrics(this.agent.getIdentity(), memInfo, loadFuture.get(), cpuFuture.get(), users);
            DuccNode node = new DuccNode(this.agent.getIdentity(), nodeMetrics);
            if (this.agent.getNodeInfo() == null) {
                this.agent.setNodeInfo((Node)node);
            }
            node.duccLingExists(this.agent.duccLingExists());
            node.runWithDuccLing(this.agent.runWithDuccLing());
            this.logger.info(methodName, null, new Object[]{"... Agent " + node.getNodeIdentity().getName() + " Posting Memory:" + node.getNodeMetrics().getNodeMemory().getMemTotal() + " Memory Free:" + node.getNodeMetrics().getNodeMemory().getMemFree() + " Swap Total:" + node.getNodeMetrics().getNodeMemory().getSwapTotal() + " Swap Free:" + node.getNodeMetrics().getNodeMemory().getSwapFree() + " Low Swap Threshold Defined in ducc.properties:" + this.swapThreshold});
            this.logger.trace(methodName, null, new Object[]{"... Agent " + node.getNodeIdentity().getName() + " Posting Users:" + node.getNodeMetrics().getNodeUsersMap().size()});
            if (this.swapThreshold > 0 && node.getNodeMetrics().getNodeMemory().getSwapFree() < (long)this.swapThreshold) {
                this.agent.killProcessDueToLowSwapSpace(this.swapThreshold);
            }
            NodeMetricsUpdateDuccEvent updateEvent = new NodeMetricsUpdateDuccEvent((Node)node, this.agent.getInventoryRef().size());
            e.getIn().setBody((Object)updateEvent, NodeMetricsUpdateDuccEvent.class);
        }
        catch (Exception ex) {
            this.logger.error(methodName, null, (Throwable)ex, new Object[]{"Agent"});
        }
    }
}

