/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.processors;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.processors.NodeInventoryProcessor;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.NodeInventoryUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class DefaultNodeInventoryProcessor
implements NodeInventoryProcessor {
    DuccLogger logger = new DuccLogger(this.getClass(), "AGENT");
    boolean inventoryChanged = true;
    private NodeAgent agent;
    private HashMap<DuccId, IDuccProcess> previousInventory;
    private int forceInventoryUpdateMaxThreshold = 0;
    private long counter = 0L;

    public DefaultNodeInventoryProcessor(NodeAgent agent, String inventoryPublishRateSkipCount) {
        this.agent = agent;
        try {
            this.forceInventoryUpdateMaxThreshold = Integer.parseInt(inventoryPublishRateSkipCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.forceInventoryUpdateMaxThreshold == 0) {
            this.forceInventoryUpdateMaxThreshold = 1;
        }
    }

    @Override
    public HashMap<DuccId, IDuccProcess> getInventory() {
        return this.agent.getInventoryCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange outgoingMessage) throws Exception {
        String methodName = "process";
        HashMap<DuccId, IDuccProcess> inventory = this.getInventory();
        if (this.previousInventory != null) {
            if (inventory.size() != this.previousInventory.size()) {
                this.inventoryChanged = true;
            } else {
                for (Map.Entry<DuccId, IDuccProcess> currentProcess : inventory.entrySet()) {
                    if (this.previousInventory.containsKey(currentProcess.getKey())) {
                        IDuccProcess previousProcess = this.previousInventory.get(currentProcess.getKey());
                        if (currentProcess.getValue().getPID() != null && previousProcess.getPID() == null) {
                            this.inventoryChanged = true;
                            break;
                        }
                        if (currentProcess.getValue().getProcessState().equals((Object)previousProcess.getProcessState())) continue;
                        this.inventoryChanged = true;
                        break;
                    }
                    this.inventoryChanged = true;
                    break;
                }
            }
        }
        this.previousInventory = inventory;
        try {
            if (inventory.size() > 0 && (this.inventoryChanged || this.forceInventoryUpdateMaxThreshold == 0 || this.counter > 0L && this.counter % (long)this.forceInventoryUpdateMaxThreshold == 0L)) {
                outgoingMessage.getIn().setBody((Object)new NodeInventoryUpdateDuccEvent(inventory));
                StringBuffer sb = new StringBuffer("Node Inventory (" + inventory.size() + ")");
                for (Map.Entry<DuccId, IDuccProcess> p : inventory.entrySet()) {
                    int pipelineInitStats = p.getValue().getUimaPipelineComponents() == null ? 0 : p.getValue().getUimaPipelineComponents().size();
                    sb.append("\n\t[Process Type=").append(p.getValue().getProcessType()).append(" DUCC ID=").append(p.getValue().getDuccId()).append(" PID=").append(p.getValue().getPID()).append(" State=").append(p.getValue().getProcessState()).append(" Resident Memory=").append(p.getValue().getResidentMemory()).append(" Init Stats List Size:" + pipelineInitStats).append("] ");
                    if (p.getValue().getProcessState().equals((Object)IProcessState.ProcessState.Stopped) || p.getValue().getProcessState().equals((Object)IProcessState.ProcessState.Failed) || p.getValue().getProcessState().equals((Object)IProcessState.ProcessState.Killed)) {
                        sb.append(" Reason:" + p.getValue().getReasonForStoppingProcess());
                    }
                    sb.append(" Exit Code=" + p.getValue().getProcessExitCode());
                }
                this.logger.info(methodName, null, new Object[]{"Agent " + this.agent.getIdentity().getName() + " Posting Inventory:" + sb.toString()});
            } else {
                outgoingMessage.getIn().setBody(null);
            }
        }
        catch (Exception e) {
            this.logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        finally {
            this.counter = this.inventoryChanged ? 0L : ++this.counter;
            this.inventoryChanged = false;
        }
    }
}

