/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.uima.ducc.agent.metrics.collectors.CallableMemoryCollector;
import org.apache.uima.ducc.common.agent.metrics.memory.NodeMemory;
import org.apache.uima.ducc.common.node.metrics.NodeMemoryInfo;
import org.apache.uima.ducc.common.utils.Utils;

public class NodeMemInfoCollector
implements CallableMemoryCollector {
    private long fakeMemorySize = -1L;
    private String[] targetFields;
    private int gidMax = 500;

    public NodeMemInfoCollector(String[] targetFields) {
        this.targetFields = targetFields;
        String tmp = System.getProperty("ducc.agent.node.metrics.fake.memory.size");
        if (tmp != null) {
            try {
                this.fakeMemorySize = Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if ((tmp = System.getProperty("ducc.agent.node.metrics.sys.gid.max")) != null) {
            try {
                this.gidMax = Integer.valueOf(tmp);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeMemory call() throws Exception {
        BufferedReader fileReader = new BufferedReader(new FileReader("/proc/meminfo"));
        long[] memInfoValues = new long[this.targetFields.length];
        try {
            String line;
            block7: while ((line = fileReader.readLine()) != null) {
                String[] parts = line.trim().split("\\s+");
                for (int i = 0; i < this.targetFields.length; ++i) {
                    if (!parts[0].equals(this.targetFields[i])) continue;
                    memInfoValues[i] = Long.parseLong(parts[1]);
                    continue block7;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fileReader.close();
        }
        long memUsed = 0L;
        if (this.fakeMemorySize == -1L) {
            memUsed = this.collectRSSFromPSCommand();
        }
        memInfoValues[1] = memInfoValues[0] - memUsed;
        return new NodeMemoryInfo(memInfoValues, this.fakeMemorySize);
    }

    private long collectRSSFromPSCommand() throws Exception {
        String line;
        InputStream stream = null;
        BufferedReader reader = null;
        ProcessBuilder pb = Utils.isMac() ? new ProcessBuilder("ps", "-Ao", "user=,pid=,uid=,rss=") : new ProcessBuilder("ps", "-Ao", "user:12,pid,uid,rss", "--no-heading");
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        stream = proc.getInputStream();
        reader = new BufferedReader(new InputStreamReader(stream));
        String regex = "\\s+";
        long memoryUsed = 0L;
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(regex);
            if (tokens.length <= 0) continue;
            try {
                int uid = Integer.valueOf(tokens[2]);
                if (uid >= this.gidMax) continue;
                memoryUsed += Long.valueOf(tokens[3]).longValue();
            }
            catch (NumberFormatException nfe) {}
        }
        stream.close();
        return memoryUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String[] meminfoTargetFields = new String[]{"MemTotal:", "MemFree:", "SwapTotal:", "SwapFree:"};
        try {
            NodeMemInfoCollector nmi = new NodeMemInfoCollector(meminfoTargetFields);
            ExecutorService pool = Executors.newFixedThreadPool(1);
            while (true) {
                Future<NodeMemory> nmiFuture = pool.submit(nmi);
                NodeMemory memInfo = nmiFuture.get();
                System.out.println("... Meminfo Data - Memory Total:" + memInfo.getMemTotal() + " Memory Free:" + memInfo.getMemFree() + " Swap Total:" + memInfo.getSwapTotal() + " Swap Free:" + memInfo.getSwapFree());
                NodeMemInfoCollector nodeMemInfoCollector = nmi;
                synchronized (nodeMemInfoCollector) {
                    nmi.wait(4000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

