/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.uima.ducc.agent.metrics.collectors.CallableMemoryCollector;
import org.apache.uima.ducc.common.agent.metrics.memory.DuccNodeMemory;
import org.apache.uima.ducc.common.agent.metrics.memory.NodeMemory;

public class DefaultNodeMemoryCollector
implements CallableMemoryCollector {
    private static final String FREE_PHYSICAL_MEMORY_SIZE = "getFreePhysicalMemorySize";
    private static final String FREE_SWAP_MEMORY_SIZE = "getFreeSwapSpaceSize";
    private static final String TOTAL_SWAP_SPACE_SIZE = "getTotalSwapSpaceSize";
    private long fakeMemorySize = -1L;

    public DefaultNodeMemoryCollector() {
        String tmp = System.getProperty("ducc.agent.node.metrics.fake.memory.size");
        if (tmp != null) {
            try {
                this.fakeMemorySize = Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public NodeMemory call() throws Exception {
        return this.collect();
    }

    private void setMetric(String metricName, long metricValue, DuccNodeMemory nodeMemory) {
        try {
            if (this.fakeMemorySize != -1L) {
                nodeMemory.setMemTotal(this.fakeMemorySize);
            } else {
                nodeMemory.setMemTotal(Runtime.getRuntime().totalMemory());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (metricName.equalsIgnoreCase(FREE_PHYSICAL_MEMORY_SIZE)) {
            nodeMemory.setMemFree(metricValue);
        } else if (metricName.equalsIgnoreCase(FREE_SWAP_MEMORY_SIZE)) {
            nodeMemory.setSwapFree(metricValue);
        } else if (metricName.equalsIgnoreCase(TOTAL_SWAP_SPACE_SIZE)) {
            nodeMemory.setSwapTotal(metricValue);
        }
    }

    private DuccNodeMemory collect() {
        DuccNodeMemory nodeMemory = new DuccNodeMemory();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
            Long value;
            method.setAccessible(true);
            if (!method.getName().startsWith("get") || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                value = (Long)method.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception e) {
                value = 0L;
            }
            this.setMetric(method.getName(), value, nodeMemory);
        }
        return nodeMemory;
    }

    public static void main(String[] args) {
        try {
            DefaultNodeMemoryCollector collector = new DefaultNodeMemoryCollector();
            ExecutorService pool = Executors.newFixedThreadPool(1);
            Future<NodeMemory> nmiFuture = pool.submit(collector);
            NodeMemory nodeMemory = nmiFuture.get();
            System.out.println("Total Memory:" + nodeMemory.getMemTotal());
            System.out.println("Total Free Memory:" + nodeMemory.getMemFree());
            System.out.println("Total Swap Space Size:" + nodeMemory.getSwapTotal());
            System.out.println("Total Free Swap Space Size:" + nodeMemory.getSwapFree());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

