/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.deploy.uima;

import java.net.InetAddress;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.uima.ducc.agent.deploy.ManagedService;
import org.apache.uima.ducc.agent.deploy.ServiceAdapter;
import org.apache.uima.ducc.agent.deploy.ServiceStateNotificationAdapter;
import org.apache.uima.ducc.agent.deploy.uima.ManagedUimaService;
import org.apache.uima.ducc.agent.deploy.uima.ProcessEventListener;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class UimaAsServiceConfiguration {
    @Autowired
    DuccTransportConfiguration transport;
    @Autowired
    CommonConfiguration common;
    RouteBuilder routeBuilder;
    CamelContext camelContext;

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String thisNodeIP, final ProcessEventListener delegate) {
        return new RouteBuilder(){
            Predicate filter;
            {
                this.filter = new DuccProcessFilter(thisNodeIP);
            }

            public void configure() throws Exception {
                System.out.println("Service Wrapper Starting Request Channel on Endpoint:" + UimaAsServiceConfiguration.this.common.managedServiceEndpoint);
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).process((Processor)new ErrorProcessor())).end();
                ((ChoiceDefinition)this.from(UimaAsServiceConfiguration.this.common.managedServiceEndpoint).choice().when(this.filter).bean((Object)delegate)).end().setId(UimaAsServiceConfiguration.this.common.managedServiceEndpoint);
            }
        };
    }

    private ProcessEventListener processDelegateListener(ManagedService service) {
        return new ProcessEventListener(service);
    }

    private ServiceStateNotificationAdapter serviceAdapter(DuccEventDispatcher eventDispatcher, String stateUpdateEndpoint) {
        return new ServiceAdapter(eventDispatcher, System.getenv("ProcessDuccId"), stateUpdateEndpoint);
    }

    @Bean
    public ManagedService managedService() throws Exception {
        try {
            String thisNodeIP = System.getenv("IP") == null ? InetAddress.getLocalHost().getHostAddress() : System.getenv("IP");
            this.camelContext = this.common.camelContext();
            int serviceSocketPort = 0;
            String agentSocketParams = "";
            String jpSocketParams = "";
            if (this.common.managedServiceEndpointParams != null) {
                jpSocketParams = "?" + this.common.managedServiceEndpointParams;
            }
            if (this.common.managedProcessStateUpdateEndpointParams != null) {
                agentSocketParams = "?" + this.common.managedProcessStateUpdateEndpointParams;
            }
            if (this.common.managedProcessStateUpdateEndpointType != null && this.common.managedProcessStateUpdateEndpointType.equalsIgnoreCase("socket")) {
                this.common.managedProcessStateUpdateEndpoint = "mina:tcp://localhost:" + System.getProperty("ducc.agent.process.state.update.port") + agentSocketParams;
            }
            if (this.common.managedServiceEndpointType != null && this.common.managedServiceEndpointType.equalsIgnoreCase("socket")) {
                serviceSocketPort = Utils.findFreePort();
                this.common.managedServiceEndpoint = "mina:tcp://localhost:" + serviceSocketPort + jpSocketParams;
            }
            DuccEventDispatcher eventDispatcher = this.transport.duccEventDispatcher(this.common.managedProcessStateUpdateEndpoint, this.camelContext);
            ManagedUimaService service = new ManagedUimaService(this.common.saxonJarPath, this.common.dd2SpringXslPath, this.serviceAdapter(eventDispatcher, this.common.managedServiceEndpoint), this.camelContext);
            service.setConfigFactory(this);
            service.setAgentStateUpdateEndpoint(this.common.managedProcessStateUpdateEndpoint);
            System.out.println("#######################################################");
            System.out.println("## Agent Service State Update Endpoint:" + this.common.managedProcessStateUpdateEndpoint + " ##");
            System.out.println("#######################################################");
            ProcessEventListener delegateListener = this.processDelegateListener(service);
            delegateListener.setDuccEventDispatcher(eventDispatcher);
            this.routeBuilder = this.routeBuilderForIncomingRequests(thisNodeIP, delegateListener);
            this.camelContext.addRoutes((RoutesBuilder)this.routeBuilder);
            return service;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void stop() throws Exception {
        if (this.camelContext != null) {
            for (Route route : this.camelContext.getRoutes()) {
                route.getConsumer().stop();
                System.out.println(">>> configFactory.stop() - stopped route:" + route.getId());
            }
        }
    }

    private class DuccProcessFilter
    implements Predicate {
        String thisNodeIP;

        public DuccProcessFilter(String thisNodeIP) {
            this.thisNodeIP = thisNodeIP;
        }

        public synchronized boolean matches(Exchange exchange) {
            boolean result = false;
            try {
                String pid = (String)exchange.getIn().getHeader("processPID");
                String targetIP = (String)exchange.getIn().getHeader("nodeip");
                if (Utils.getPID().equals(pid) && this.thisNodeIP.equals(targetIP)) {
                    result = true;
                    System.out.println(">>>>>>>>> Process Received a Message. Is Process target for message:" + result + ". Target PID:" + pid);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            caused.printStackTrace();
        }
    }
}

