/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.uima.ducc.agent.metrics.collectors.CallableMemoryCollector;
import org.apache.uima.ducc.common.agent.metrics.memory.NodeMemory;
import org.apache.uima.ducc.common.node.metrics.NodeMemoryInfo;

public class NodeMemInfoCollector
implements CallableMemoryCollector {
    private long fakeMemorySize = -1L;
    private String[] targetFields;

    public NodeMemInfoCollector(String[] targetFields) {
        this.targetFields = targetFields;
        String tmp = System.getProperty("ducc.agent.node.metrics.fake.memory.size");
        if (tmp != null) {
            try {
                this.fakeMemorySize = Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeMemory call() throws Exception {
        BufferedReader fileReader = new BufferedReader(new FileReader("/proc/meminfo"));
        long[] memInfoValues = new long[this.targetFields.length];
        try {
            String line;
            block7: while ((line = fileReader.readLine()) != null) {
                String[] parts = line.trim().split("\\s+");
                for (int i = 0; i < this.targetFields.length; ++i) {
                    if (!parts[0].equals(this.targetFields[i])) continue;
                    memInfoValues[i] = Long.parseLong(parts[1]);
                    continue block7;
                }
            }
            return new NodeMemoryInfo(memInfoValues, this.fakeMemorySize);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String[] meminfoTargetFields = new String[]{"MemTotal:", "MemFree:", "SwapTotal:", "SwapFree:"};
        try {
            NodeMemInfoCollector nmi = new NodeMemInfoCollector(meminfoTargetFields);
            ExecutorService pool = Executors.newFixedThreadPool(1);
            while (true) {
                Future<NodeMemory> nmiFuture = pool.submit(nmi);
                NodeMemory memInfo = nmiFuture.get();
                System.out.println("... Memonfo Data:" + memInfo.getMemTotal() + " Memory Free:" + memInfo.getMemFree() + " Swap Total:" + memInfo.getSwapTotal() + " Swap Free:" + memInfo.getSwapFree());
                NodeMemInfoCollector nodeMemInfoCollector = nmi;
                synchronized (nodeMemInfoCollector) {
                    nmi.wait(4000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

