/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class ProcessStreamConsumer
extends Thread {
    public static final String LS = System.getProperty("line.separator");
    private InputStream is;
    private PrintStream os;
    DuccLogger logger;
    private DuccId workDuccId;
    private StringBuffer errStreamBuffer = new StringBuffer();

    public ProcessStreamConsumer(DuccLogger logger, ThreadGroup threadGroup, String threadName, InputStream is, PrintStream os, DuccId workDuccId) {
        super(threadGroup, threadName);
        this.os = os;
        this.is = is;
        this.logger = logger;
        this.setDaemon(true);
        this.workDuccId = workDuccId;
    }

    public String getDataFromStream() {
        return this.errStreamBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line;
            InputStreamReader in = new InputStreamReader(this.is);
            BufferedReader reader = new BufferedReader(in);
            while ((line = reader.readLine()) != null) {
                line = line + LS;
                if ("StdErrorReader".equals(Thread.currentThread().getName())) {
                    this.logger.error("ProcessStreamConsumer.run()", this.workDuccId, new Object[]{line.trim()});
                    this.os.print("ERR>>>" + line);
                    this.errStreamBuffer.append(line.trim());
                    continue;
                }
                this.logger.info("ProcessStreamConsumer.run()", this.workDuccId, new Object[]{line.trim()});
                this.os.print("OUT>>>" + line);
            }
        }
        catch (Exception x) {
        }
        finally {
            try {
                this.os.flush();
            }
            catch (Exception e) {
                System.out.println("Caught Exception While Flushing " + Thread.currentThread().getName() + " Output Stream");
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

