/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.event.ProcessLifecycleObserver;
import org.apache.uima.ducc.agent.launcher.DuccCommandExecutor;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.launcher.Process;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.cmdline.JavaCommandLine;
import org.apache.uima.ducc.transport.event.common.DuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;

public class Launcher {
    private ExecutorService executorService = null;
    private DuccIdFactory duccIdFactory = new DuccIdFactory();

    public Launcher() {
        this.executorService = Executors.newCachedThreadPool();
    }

    public void start(ICommandLine cmdLine, int howMany, String ip, String nodeName) throws Exception {
        for (int i = 0; i < howMany; ++i) {
            String host = nodeName;
            if (host.indexOf(".") > -1) {
                String tmp = host.substring(0, host.indexOf("."));
                host = tmp + "-" + String.valueOf(i + 1) + host.substring(host.indexOf("."));
            } else {
                host = host + "-" + String.valueOf(i + 1);
            }
            this.launchProcess(host, ip, cmdLine);
            int uip = Integer.parseInt(ip.substring(ip.lastIndexOf(".") + 1, ip.length()));
            ip = ip.substring(0, ip.lastIndexOf(".") + 1).concat(String.valueOf(uip + 1));
        }
    }

    public ManagedProcess launchProcess(NodeAgent agent, NodeIdentity nodeIdentity, IDuccProcess process, ICommandLine commandLine, ProcessLifecycleObserver observer, ManagedProcess managedProcess) throws Exception {
        DuccCommandExecutor executor = new DuccCommandExecutor(agent, commandLine, nodeIdentity.getName(), nodeIdentity.getIp(), managedProcess);
        Future<Process> future = this.executorService.submit(executor);
        managedProcess.setFuture(future);
        return managedProcess;
    }

    public void launchProcess(String host, String ip, ICommandLine cmdLine) throws Exception {
        DuccProcess process = new DuccProcess(this.duccIdFactory.next(), new NodeIdentity(ip, host));
        process.setProcessType(IDuccProcessType.ProcessType.Pop);
        ManagedProcess managedProcess = new ManagedProcess((IDuccProcess)process, cmdLine, true);
        DuccCommandExecutor executor = new DuccCommandExecutor(cmdLine, host, ip, managedProcess);
        this.executorService.submit(executor);
    }

    public static void main(String[] args) {
        try {
            int howMany = Integer.parseInt(args[0]);
            String ip = System.getProperty("IP");
            String nodeName = InetAddress.getLocalHost().getHostName();
            Launcher launcher = new Launcher();
            JavaCommandLine cmdLine = new JavaCommandLine("java");
            String duccHome = Utils.findDuccHome();
            cmdLine.addOption("-Dducc.deploy.configuration=" + duccHome + "/resources/ducc.properties");
            cmdLine.addOption("-Dducc.deploy.components=agent");
            cmdLine.addOption("-Djava.library.path=" + duccHome + "/lib/sigar");
            cmdLine.addOption("-DDUCC_HOME=" + duccHome);
            cmdLine.setClasspath(System.getProperty("java.class.path"));
            cmdLine.setClassName("org.apache.uima.ducc.agent.common.main.DuccService");
            launcher.start((ICommandLine)cmdLine, howMany, ip, nodeName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

