/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.deploy;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.uima.ducc.agent.deploy.ManagedService;
import org.apache.uima.ducc.agent.deploy.ServiceStateNotificationAdapter;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public abstract class AbstractManagedService
extends AbstractDuccComponent
implements ManagedService {
    public static final String ManagedServiceNotificationInterval = "uima.process.notify.interval";
    private long notificationInterval = 5000L;
    protected IProcessState.ProcessState currentState = IProcessState.ProcessState.Undefined;
    protected IProcessState.ProcessState previousState = IProcessState.ProcessState.Undefined;
    public boolean useJmx = false;
    public ServiceStateNotificationAdapter serviceAdapter = null;

    public abstract void quiesceAndStop();

    public abstract void deploy(String[] var1) throws Exception;

    protected AbstractManagedService(ServiceStateNotificationAdapter serviceAdapter, CamelContext context) {
        super("UimaProcess", context);
        this.serviceAdapter = serviceAdapter;
    }

    public long getNotificationInterval() {
        return this.notificationInterval;
    }

    public void setNotificationInterval(long notificationInterval) {
        this.notificationInterval = notificationInterval;
    }

    public void initialize() throws Exception {
        ServiceShutdownHook shutdownHook = new ServiceShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        System.out.println("Managed Service Wrapper Registered Shutdown Hook");
    }

    public void notifyAgentWithStatus(IProcessState.ProcessState state) {
        this.serviceAdapter.notifyAgentWithStatus(state);
    }

    public void notifyAgentWithStatus(IProcessState.ProcessState state, String message) {
        this.serviceAdapter.notifyAgentWithStatus(state, message);
    }

    public void notifyAgentWithStatus(List<IUimaPipelineAEComponent> pipeline) {
        this.serviceAdapter.notifyAgentWithStatus(pipeline);
    }

    protected void stopIt() {
        if (this.serviceAdapter != null) {
            // empty if block
        }
    }

    public IProcessState.ProcessState getServiceState() {
        return this.currentState;
    }

    public void start(DuccService service, String[] args) throws Exception {
        try {
            super.start(service, args);
            this.deploy(args);
        }
        catch (Exception e) {
            this.currentState = IProcessState.ProcessState.FailedInitialization;
            this.notifyAgentWithStatus(IProcessState.ProcessState.FailedInitialization);
            throw e;
        }
    }

    public void stop() {
        try {
            System.out.println("... AbstractManagedService - Stopping Service Adapter");
            this.serviceAdapter.stop();
            System.out.println("... AbstractManagedService - Calling super.stop() ");
            super.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class ServiceShutdownHook
    extends Thread {
        private AbstractManagedService managedService;

        public ServiceShutdownHook(AbstractManagedService service) {
            this.managedService = service;
        }

        @Override
        public void run() {
            try {
                System.out.println("Uima AS Service Wrapper Caught Kill Signal - Initiating Quiesce and Stop");
                this.managedService.quiesceAndStop();
                this.managedService.stopIt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

