/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent;

import java.util.TimerTask;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;

public class ProcessReaperTask
extends TimerTask {
    private NodeAgent agent;
    private DuccLogger logger;

    public ProcessReaperTask(NodeAgent agent, DuccLogger logger) {
        this.agent = agent;
        this.logger = logger;
    }

    @Override
    public void run() {
        if (this.agent.deployedProcesses.size() > 0) {
            this.logger.warn("ProcessReaperTask.run()", null, new Object[]{"Agent timed out waiting for a Ping Message. Assuming network connectivity problem and killing all running JPs"});
            for (ManagedProcess mp : this.agent.deployedProcesses) {
                mp.kill();
                mp.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.AgentTimedOutWaitingForORState.toString());
                String pid = mp.getDuccProcess().getPID();
                this.agent.stopProcess(mp.getDuccProcess());
                this.logger.info("ProcessReaperTask.run()", null, new Object[]{"Agent calling stopProcess:" + pid});
            }
        }
    }
}

