/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.tuweni.scuttlebutt.lib.FeedService;
import org.apache.tuweni.scuttlebutt.lib.NetworkService;
import org.apache.tuweni.scuttlebutt.lib.RawRequestService;
import org.apache.tuweni.scuttlebutt.lib.SocialService;
import org.apache.tuweni.scuttlebutt.rpc.mux.Multiplexer;

public class ScuttlebuttClient {
    private final Multiplexer multiplexer;
    private final FeedService feedService;

    protected ScuttlebuttClient(Multiplexer multiplexer, ObjectMapper mapper) {
        this.multiplexer = multiplexer;
        this.feedService = new FeedService(multiplexer, mapper);
    }

    public NetworkService getNetworkService() {
        return new NetworkService(this.multiplexer);
    }

    public FeedService getFeedService() {
        return this.feedService;
    }

    public SocialService getSocialService() {
        return new SocialService(this.multiplexer, this.feedService);
    }

    public RawRequestService rawRequestService() {
        return new RawRequestService(this.multiplexer);
    }
}

