/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.scuttlebutt.Invite;
import org.apache.tuweni.scuttlebutt.MalformedInviteCodeException;
import org.apache.tuweni.scuttlebutt.lib.model.Peer;
import org.apache.tuweni.scuttlebutt.lib.model.PeerStateChange;
import org.apache.tuweni.scuttlebutt.lib.model.StreamHandler;
import org.apache.tuweni.scuttlebutt.rpc.RPCAsyncRequest;
import org.apache.tuweni.scuttlebutt.rpc.RPCFunction;
import org.apache.tuweni.scuttlebutt.rpc.RPCResponse;
import org.apache.tuweni.scuttlebutt.rpc.RPCStreamRequest;
import org.apache.tuweni.scuttlebutt.rpc.mux.Multiplexer;
import org.apache.tuweni.scuttlebutt.rpc.mux.ScuttlebuttStreamHandler;
import org.apache.tuweni.scuttlebutt.rpc.mux.exceptions.ConnectionClosedException;

public class NetworkService {
    private final Multiplexer multiplexer;
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    protected NetworkService(Multiplexer multiplexer) {
        this.multiplexer = multiplexer;
    }

    public AsyncResult<Invite> generateInviteCode(int validForUses) {
        RPCFunction function = new RPCFunction(Arrays.asList("invite"), "create");
        RPCAsyncRequest request = new RPCAsyncRequest(function, Arrays.asList(validForUses));
        try {
            return this.multiplexer.makeAsyncRequest(request).then(response -> {
                try {
                    return AsyncResult.completed((Object)this.inviteFromRPCResponse((RPCResponse)response));
                }
                catch (MalformedInviteCodeException malformedInviteCodeException) {
                    return AsyncResult.exceptional((Throwable)malformedInviteCodeException);
                }
            });
        }
        catch (JsonProcessingException ex) {
            return AsyncResult.exceptional((Throwable)ex);
        }
    }

    public AsyncResult<Void> redeemInviteCode(Invite invite) {
        RPCFunction function = new RPCFunction(Arrays.asList("invite"), "accept");
        RPCAsyncRequest request = new RPCAsyncRequest(function, Arrays.asList(invite.toCanonicalForm()));
        try {
            return this.multiplexer.makeAsyncRequest(request).thenApply(r -> null);
        }
        catch (JsonProcessingException ex) {
            return AsyncResult.exceptional((Throwable)ex);
        }
    }

    public AsyncResult<List<Peer>> getConnectedPeers() {
        return this.getAllKnownPeers().thenApply(peers -> peers.stream().filter(peer -> peer.getState().equals("connected")).collect(Collectors.toList()));
    }

    public AsyncResult<List<Peer>> getAllKnownPeers() {
        RPCFunction function = new RPCFunction(Arrays.asList("gossip"), "peers");
        RPCAsyncRequest request = new RPCAsyncRequest(function, Arrays.asList(new Object[0]));
        try {
            return this.multiplexer.makeAsyncRequest(request).then(rpcResponse -> {
                try {
                    List peers = (List)rpcResponse.asJSON(this.mapper, (TypeReference)new TypeReference<List<Peer>>(){});
                    return AsyncResult.completed((Object)peers);
                }
                catch (IOException e) {
                    return AsyncResult.exceptional((Throwable)e);
                }
            });
        }
        catch (JsonProcessingException e) {
            return AsyncResult.exceptional((Throwable)e);
        }
    }

    public void createChangesStream(final Function<Runnable, StreamHandler<PeerStateChange>> streamHandler) throws JsonProcessingException, ConnectionClosedException {
        RPCFunction function = new RPCFunction(Arrays.asList("gossip"), "changes");
        RPCStreamRequest request = new RPCStreamRequest(function, Arrays.asList(new Object[0]));
        this.multiplexer.openStream(request, closer -> new ScuttlebuttStreamHandler((Runnable)closer){
            StreamHandler changeStream;
            final /* synthetic */ Runnable val$closer;
            {
                this.val$closer = runnable;
                this.changeStream = (StreamHandler)streamHandler.apply(this.val$closer);
            }

            public void onMessage(RPCResponse message) {
                try {
                    PeerStateChange peerStateChange = (PeerStateChange)message.asJSON(NetworkService.this.mapper, PeerStateChange.class);
                    this.changeStream.onMessage(peerStateChange);
                }
                catch (IOException e) {
                    this.changeStream.onStreamError(e);
                    this.val$closer.run();
                }
            }

            public void onStreamEnd() {
                this.changeStream.onStreamEnd();
            }

            public void onStreamError(Exception ex) {
                this.changeStream.onStreamError(ex);
            }
        });
    }

    private Invite inviteFromRPCResponse(RPCResponse response) throws MalformedInviteCodeException {
        String rawInviteCode = response.asString();
        return Invite.fromCanonicalForm((String)rawInviteCode);
    }
}

