/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.io.Base64;

public class KeyFileLoader {
    public static Signature.KeyPair getLocalKeys() throws Exception {
        Optional path = Optional.fromNullable((Object)System.getenv().get("ssb_dir"));
        if (!path.isPresent()) {
            throw new Exception("Cannot find ssb directory config value");
        }
        String secretPath = (String)path.get() + "/secret";
        File file = new File(secretPath);
        if (!file.exists()) {
            throw new Exception("Secret file does not exist");
        }
        return KeyFileLoader.loadKeysFromFile(secretPath);
    }

    public static Signature.KeyPair loadKeysFromFile(String secretPath) throws IOException {
        File file = new File(secretPath);
        Scanner s = new Scanner(file, StandardCharsets.UTF_8.name());
        s.useDelimiter("\n");
        ArrayList<String> list = new ArrayList<String>();
        while (s.hasNext()) {
            String next = s.next();
            if (next.startsWith("#")) continue;
            list.add(next);
        }
        String secretJSON = String.join((CharSequence)"", list);
        ObjectMapper mapper = new ObjectMapper();
        HashMap values = (HashMap)mapper.readValue(secretJSON, (TypeReference)new TypeReference<Map<String, String>>(){});
        String pubKey = ((String)values.get("public")).replace(".ed25519", "");
        String privateKey = ((String)values.get("private")).replace(".ed25519", "");
        Bytes pubKeyBytes = Base64.decode((String)pubKey);
        Bytes privKeyBytes = Base64.decode((String)privateKey);
        Signature.PublicKey pub = Signature.PublicKey.fromBytes((Bytes)pubKeyBytes);
        Signature.SecretKey secretKey = Signature.SecretKey.fromBytes((Bytes)privKeyBytes);
        return new Signature.KeyPair(pub, secretKey);
    }
}

