/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.scuttlebutt.lib.FeedService;
import org.apache.tuweni.scuttlebutt.lib.model.Profile;
import org.apache.tuweni.scuttlebutt.lib.model.UpdateNameMessage;
import org.apache.tuweni.scuttlebutt.lib.model.query.AboutQuery;
import org.apache.tuweni.scuttlebutt.lib.model.query.AboutQueryResponse;
import org.apache.tuweni.scuttlebutt.lib.model.query.IsFollowingQuery;
import org.apache.tuweni.scuttlebutt.lib.model.query.IsFollowingResponse;
import org.apache.tuweni.scuttlebutt.lib.model.query.WhoAmIResponse;
import org.apache.tuweni.scuttlebutt.rpc.RPCAsyncRequest;
import org.apache.tuweni.scuttlebutt.rpc.RPCFunction;
import org.apache.tuweni.scuttlebutt.rpc.mux.Multiplexer;

public class SocialService {
    private final Multiplexer multiplexer;
    private final FeedService feedService;
    private ObjectMapper mapper = new ObjectMapper();

    protected SocialService(Multiplexer multiplexer, FeedService feedService) {
        this.multiplexer = multiplexer;
        this.feedService = feedService;
    }

    public AsyncResult<String> getOwnIdentity() {
        RPCFunction function = new RPCFunction("whoami");
        RPCAsyncRequest request = new RPCAsyncRequest(function, Arrays.asList(new Object[0]));
        try {
            return this.multiplexer.makeAsyncRequest(request).then(response -> {
                try {
                    return AsyncResult.completed((Object)((WhoAmIResponse)response.asJSON(this.mapper, WhoAmIResponse.class)).getId());
                }
                catch (IOException e) {
                    return AsyncResult.exceptional((Throwable)e);
                }
            });
        }
        catch (JsonProcessingException e) {
            return AsyncResult.exceptional((Throwable)e);
        }
    }

    public AsyncResult<Profile> getOwnProfile() {
        return this.getOwnIdentity().then(identity -> this.getProfile((String)identity));
    }

    public AsyncResult<List<Profile>> getFollowing() {
        return this.getHops().then(followHops -> {
            List<String> following = followHops.keySet().stream().filter(key -> (Integer)followHops.get(key) == 1).collect(Collectors.toList());
            return this.getProfiles(following);
        });
    }

    public AsyncResult<List<Profile>> getFollowedBy() {
        return this.getOwnIdentity().then(ownIdentity -> this.getHops().then(hops -> {
            Set identities = hops.keySet();
            List results = identities.stream().map(ident -> this.isFollowing((String)ident, (String)ownIdentity)).collect(Collectors.toList());
            AsyncResult allResults = AsyncResult.combine(results);
            AsyncResult ids = allResults.thenApply(queryResults -> queryResults.stream().filter(result -> result.isFollowing()).map(IsFollowingResponse::getSource).collect(Collectors.toList()));
            return ids.then(this::getProfiles);
        }));
    }

    public AsyncResult<List<Profile>> getFriends() {
        return this.getOwnIdentity().then(ident -> this.getFollowing().then(following -> {
            List responses = following.stream().map(follow -> this.isFollowing(follow.getKey(), (String)ident)).collect(Collectors.toList());
            return AsyncResult.combine(responses).then(response -> {
                List profiles = response.stream().filter(f -> f.isFollowing()).map(item -> this.getProfile(item.getSource())).collect(Collectors.toList());
                return AsyncResult.combine(profiles);
            });
        }));
    }

    public AsyncResult<Profile> getProfile(String publicKey) {
        RPCFunction function = new RPCFunction(Arrays.asList("about"), "latestValues");
        AboutQuery query = new AboutQuery(publicKey, Arrays.asList("name"));
        RPCAsyncRequest rpcAsyncRequest = new RPCAsyncRequest(function, Arrays.asList(query));
        try {
            AsyncResult rpcResponseAsyncResult = this.multiplexer.makeAsyncRequest(rpcAsyncRequest);
            return rpcResponseAsyncResult.then(rpcResponse -> {
                try {
                    AboutQueryResponse aboutQueryResponse = (AboutQueryResponse)rpcResponse.asJSON(this.mapper, AboutQueryResponse.class);
                    return AsyncResult.completed((Object)new Profile(publicKey, aboutQueryResponse.getName()));
                }
                catch (IOException e) {
                    return AsyncResult.exceptional((Throwable)e);
                }
            });
        }
        catch (JsonProcessingException e) {
            return AsyncResult.exceptional((Throwable)e);
        }
    }

    public AsyncResult<Profile> setDisplayName(String displayName) {
        return this.getOwnIdentity().then(ownId -> {
            try {
                return this.feedService.publish(new UpdateNameMessage(displayName, (String)ownId)).then(feedMessage -> this.getProfile((String)ownId));
            }
            catch (JsonProcessingException e) {
                return AsyncResult.exceptional((Throwable)e);
            }
        });
    }

    private AsyncResult<Map<String, Integer>> getHops() {
        RPCFunction rpcFunction = new RPCFunction(Arrays.asList("friends"), "hops");
        RPCAsyncRequest rpcAsyncRequest = new RPCAsyncRequest(rpcFunction, Arrays.asList(new Object[0]));
        try {
            AsyncResult rpcResponseAsyncResult = this.multiplexer.makeAsyncRequest(rpcAsyncRequest);
            return rpcResponseAsyncResult.then(rpcResponse -> {
                try {
                    Map followHops = (Map)rpcResponse.asJSON(this.mapper, (TypeReference)new TypeReference<Map<String, Integer>>(){});
                    return AsyncResult.completed((Object)followHops);
                }
                catch (IOException e) {
                    return AsyncResult.exceptional((Throwable)e);
                }
            });
        }
        catch (JsonProcessingException e) {
            return AsyncResult.exceptional((Throwable)e);
        }
    }

    private AsyncResult<IsFollowingResponse> isFollowing(String source, String destination) {
        RPCFunction function = new RPCFunction(Arrays.asList("friends"), "isFollowing");
        RPCAsyncRequest rpcAsyncRequest = new RPCAsyncRequest(function, Arrays.asList(new IsFollowingQuery(source, destination)));
        try {
            return this.multiplexer.makeAsyncRequest(rpcAsyncRequest).then(rpcResponse -> {
                try {
                    boolean answer = (Boolean)rpcResponse.asJSON(this.mapper, Boolean.class);
                    return AsyncResult.completed((Object)new IsFollowingResponse(source, destination, answer));
                }
                catch (IOException e) {
                    return AsyncResult.exceptional((Throwable)e);
                }
            });
        }
        catch (JsonProcessingException e) {
            return AsyncResult.exceptional((Throwable)e);
        }
    }

    private AsyncResult<List<Profile>> getProfiles(List<String> keys) {
        List asyncResultStream = keys.stream().map(this::getProfile).collect(Collectors.toList());
        return AsyncResult.combine(asyncResultStream);
    }
}

