/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.Vertx;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.io.Base64;
import org.apache.tuweni.scuttlebutt.handshake.vertx.SecureScuttlebuttVertxClient;
import org.apache.tuweni.scuttlebutt.lib.ScuttlebuttClient;
import org.apache.tuweni.scuttlebutt.rpc.mux.Multiplexer;
import org.apache.tuweni.scuttlebutt.rpc.mux.RPCHandler;
import org.logl.Level;
import org.logl.LoggerProvider;
import org.logl.logl.AdjustableLoggerProvider;
import org.logl.logl.SimpleLogger;

public final class ScuttlebuttClientFactory {
    public static Bytes32 DEFAULT_NETWORK = ScuttlebuttClientFactory.defaultNetwork();

    public static Bytes32 defaultNetwork() {
        String networkKeyBase64 = "1KHLiKZvAvjbY1ziZEHMXawbCEIM6qwjCDm3VYRan/s=";
        return Bytes32.wrap((Bytes)Base64.decode((String)networkKeyBase64));
    }

    private ScuttlebuttClientFactory() {
    }

    public static AsyncResult<ScuttlebuttClient> fromNet(ObjectMapper mapper, String host, int port, Signature.KeyPair keyPair) {
        Vertx vertx = Vertx.vertx();
        return ScuttlebuttClientFactory.fromNetWithVertx(mapper, vertx, host, port, keyPair);
    }

    public static AsyncResult<ScuttlebuttClient> fromNetWithVertx(ObjectMapper mapper, Vertx vertx, String host, int port, Signature.KeyPair keyPair) {
        AdjustableLoggerProvider loggerProvider = SimpleLogger.withLogLevel((Level)Level.DEBUG).toPrintWriter(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8))));
        return ScuttlebuttClientFactory.fromNetWithNetworkKey(vertx, host, port, keyPair, DEFAULT_NETWORK, mapper, (LoggerProvider)loggerProvider);
    }

    public static AsyncResult<ScuttlebuttClient> fromNetWithNetworkKey(Vertx vertx, String host, int port, Signature.KeyPair keyPair, Bytes32 networkIdentifier, ObjectMapper objectMapper, LoggerProvider loggerProvider) {
        SecureScuttlebuttVertxClient secureScuttlebuttVertxClient = new SecureScuttlebuttVertxClient(loggerProvider, vertx, keyPair, networkIdentifier);
        return secureScuttlebuttVertxClient.connectTo(port, host, keyPair.publicKey(), (sender, terminationFn) -> new RPCHandler(vertx, sender, terminationFn, objectMapper, loggerProvider)).thenApply(handler -> new ScuttlebuttClient((Multiplexer)handler, objectMapper));
    }
}

