/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.internal.handler;

import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.v5.MessageHandler;
import org.apache.tuweni.devp2p.v5.UdpConnector;
import org.apache.tuweni.devp2p.v5.packet.TicketMessage;
import org.apache.tuweni.devp2p.v5.topic.Ticket;
import org.apache.tuweni.devp2p.v5.topic.TicketHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/devp2p/v5/internal/handler/TicketMessageHandler;", "Lorg/apache/tuweni/devp2p/v5/MessageHandler;", "Lorg/apache/tuweni/devp2p/v5/packet/TicketMessage;", "()V", "handle", "", "message", "address", "Ljava/net/InetSocketAddress;", "srcNodeId", "Lorg/apache/tuweni/bytes/Bytes;", "connector", "Lorg/apache/tuweni/devp2p/v5/UdpConnector;", "(Lorg/apache/tuweni/devp2p/v5/packet/TicketMessage;Ljava/net/InetSocketAddress;Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/devp2p/v5/UdpConnector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "devp2p"})
public final class TicketMessageHandler
implements MessageHandler<TicketMessage> {
    @Override
    @Nullable
    public Object handle(@NotNull TicketMessage message, @NotNull InetSocketAddress address, @NotNull Bytes srcNodeId, @NotNull UdpConnector connector, @NotNull Continuation<? super Unit> $completion) {
        TicketHolder ticketHolder = connector.getTicketHolder();
        ticketHolder.put(message.getRequestId(), message.getTicket());
        if (message.getWaitTime() != 0L) {
            Bytes key = connector.getSessionInitiatorKey(srcNodeId);
            Ticket ticket = Ticket.Companion.decrypt(message.getTicket(), key);
            return connector.getTopicRegistrar().delayRegTopic(message.getRequestId(), ticket.getTopic(), message.getWaitTime(), $completion);
        }
        return Unit.INSTANCE;
    }
}

