/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.nio.ByteBuffer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/apache/tuweni/devp2p/ENRRequestPacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "expiration", "", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;J)V", "encodeTo", "Ljava/nio/ByteBuffer;", "dst", "Companion", "devp2p"})
public final class ENRRequestPacket
extends Packet {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ByteBuffer encodeTo(@NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return this.encodeTo(dst, PacketType.ENRREQUEST, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ ENRRequestPacket this$0;

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.ENRRequestPacket$Companion.access$encodeTo(ENRRequestPacket.Companion, writer, this.this$0.getExpiration());
            }
            {
                this.this$0 = eNRRequestPacket;
                super(1);
            }
        }));
    }

    private ENRRequestPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, long expiration) {
        super(nodeId, signature, hash, expiration, null);
    }

    public /* synthetic */ ENRRequestPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, long expiration, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, expiration);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/apache/tuweni/devp2p/ENRRequestPacket$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/Packet;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "decode", "Lorg/apache/tuweni/devp2p/ENRRequestPacket;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "devp2p"})
    public static final class Companion {
        @NotNull
        public final ENRRequestPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, (Function)new Function<RLPReader, T>(publicKey, signature, hash){
                    final /* synthetic */ SECP256K1.PublicKey $publicKey;
                    final /* synthetic */ SECP256K1.Signature $signature;
                    final /* synthetic */ Bytes32 $hash;

                    @NotNull
                    public final ENRRequestPacket apply(RLPReader reader) {
                        long expiration = reader.readLong();
                        return new ENRRequestPacket(this.$publicKey, this.$signature, this.$hash, PacketKt.access$secToMsec(expiration), null);
                    }
                    {
                        this.$publicKey = publicKey;
                        this.$signature = signature;
                        this.$hash = bytes32;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RLP.decodeList(payload) \u2026ec(expiration))\n        }");
                return (ENRRequestPacket)object;
            }
            catch (RLPException e) {
                throw (Throwable)new DecodingException("Invalid enr request packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, long expiration) {
            writer.writeLong(PacketKt.access$msecToSec(expiration));
        }

        @NotNull
        public final Packet create(@NotNull SECP256K1.KeyPair keyPair, long now) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            long expiration = Packet.Companion.expirationFor(now);
            SigHash sigHash2 = Packet.Companion.createSignature(PacketType.ENRRESPONSE, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(expiration){
                final /* synthetic */ long $expiration;

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.ENRRequestPacket$Companion.access$encodeTo(ENRRequestPacket.Companion, writer, this.$expiration);
                }
                {
                    this.$expiration = l;
                    super(1);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.publicKey()");
            return new ENRRequestPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), expiration, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, long expiration) {
            $this.encodeTo(writer, expiration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

