/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.PingPacket;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/apache/tuweni/devp2p/PingPacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "from", "Lorg/apache/tuweni/devp2p/Endpoint;", "to", "expiration", "", "enrSeq", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/devp2p/Endpoint;JLjava/lang/Long;)V", "getEnrSeq", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getFrom", "()Lorg/apache/tuweni/devp2p/Endpoint;", "getTo", "encodeTo", "Ljava/nio/ByteBuffer;", "dst", "Companion", "devp2p"})
public final class PingPacket
extends Packet {
    @NotNull
    private final Endpoint from;
    @NotNull
    private final Endpoint to;
    @Nullable
    private final Long enrSeq;
    private static final int VERSION = 4;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ByteBuffer encodeTo(@NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return this.encodeTo(dst, PacketType.PING, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ PingPacket this$0;

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.PingPacket$Companion.access$encodeTo(PingPacket.Companion, writer, this.this$0.getFrom(), this.this$0.getTo(), this.this$0.getExpiration(), this.this$0.getEnrSeq());
            }
            {
                this.this$0 = pingPacket;
                super(1);
            }
        }));
    }

    @NotNull
    public final Endpoint getFrom() {
        return this.from;
    }

    @NotNull
    public final Endpoint getTo() {
        return this.to;
    }

    @Nullable
    public final Long getEnrSeq() {
        return this.enrSeq;
    }

    private PingPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint from2, Endpoint to2, long expiration, Long enrSeq) {
        super(nodeId, signature, hash, expiration, null);
        this.from = from2;
        this.to = to2;
        this.enrSeq = enrSeq;
    }

    public /* synthetic */ PingPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint from2, Endpoint to2, long expiration, Long enrSeq, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, from2, to2, expiration, enrSeq);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J7\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/apache/tuweni/devp2p/PingPacket$Companion;", "", "()V", "VERSION", "", "create", "Lorg/apache/tuweni/devp2p/PingPacket;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "from", "Lorg/apache/tuweni/devp2p/Endpoint;", "to", "seq", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/devp2p/Endpoint;Ljava/lang/Long;)Lorg/apache/tuweni/devp2p/PingPacket;", "decode", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "(Lorg/apache/tuweni/rlp/RLPWriter;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/devp2p/Endpoint;JLjava/lang/Long;)V", "devp2p"})
    public static final class Companion {
        @NotNull
        public final PingPacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull Endpoint from2, @NotNull Endpoint to2, @Nullable Long seq) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Intrinsics.checkParameterIsNotNull((Object)from2, (String)"from");
            Intrinsics.checkParameterIsNotNull((Object)to2, (String)"to");
            long expiration = Packet.Companion.expirationFor(now);
            SigHash sigHash2 = Packet.Companion.createSignature(PacketType.PING, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(from2, to2, expiration, seq){
                final /* synthetic */ Endpoint $from;
                final /* synthetic */ Endpoint $to;
                final /* synthetic */ long $expiration;
                final /* synthetic */ Long $seq;

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.PingPacket$Companion.access$encodeTo(PingPacket.Companion, writer, this.$from, this.$to, this.$expiration, this.$seq);
                }
                {
                    this.$from = endpoint;
                    this.$to = endpoint2;
                    this.$expiration = l;
                    this.$seq = l2;
                    super(1);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.publicKey()");
            return new PingPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), from2, to2, expiration, seq, null);
        }

        @NotNull
        public final PingPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, (Function)new Function<RLPReader, T>(publicKey, signature, hash){
                    final /* synthetic */ SECP256K1.PublicKey $publicKey;
                    final /* synthetic */ SECP256K1.Signature $signature;
                    final /* synthetic */ Bytes32 $hash;

                    @NotNull
                    public final PingPacket apply(RLPReader reader) {
                        int version = reader.readInt();
                        Endpoint from2 = (Endpoint)reader.readList((Function)decode.from.1.INSTANCE);
                        Endpoint to2 = (Endpoint)reader.readList((Function)decode.to.1.INSTANCE);
                        long expiration = reader.readLong();
                        Long seq = null;
                        RLPReader rLPReader = reader;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rLPReader, (String)"reader");
                        seq = !rLPReader.isComplete() ? Long.valueOf(reader.readLong()) : (Long)null;
                        if (version < 4) {
                            throw (Throwable)new DecodingException("Unexpected version 4 in ping", null, 2, null);
                        }
                        Endpoint endpoint = from2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)endpoint, (String)"from");
                        Endpoint endpoint2 = to2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)endpoint2, (String)"to");
                        return new PingPacket(this.$publicKey, this.$signature, this.$hash, endpoint, endpoint2, PacketKt.access$secToMsec(expiration), seq, null);
                    }
                    {
                        this.$publicKey = publicKey;
                        this.$signature = signature;
                        this.$hash = bytes32;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RLP.decodeList(payload) \u2026piration), seq)\n        }");
                return (PingPacket)object;
            }
            catch (RLPException e) {
                throw (Throwable)new DecodingException("Invalid ping packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, Endpoint from2, Endpoint to2, long expiration, Long seq) {
            block0: {
                writer.writeInt(4);
                writer.writeList((Consumer)new Consumer<RLPWriter>(from2){
                    final /* synthetic */ Endpoint $from;

                    public final void accept(RLPWriter w) {
                        RLPWriter rLPWriter = w;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"w");
                        this.$from.writeTo$devp2p(rLPWriter);
                    }
                    {
                        this.$from = endpoint;
                    }
                });
                writer.writeList((Consumer)new Consumer<RLPWriter>(to2){
                    final /* synthetic */ Endpoint $to;

                    public final void accept(RLPWriter w) {
                        RLPWriter rLPWriter = w;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"w");
                        this.$to.writeTo$devp2p(rLPWriter);
                    }
                    {
                        this.$to = endpoint;
                    }
                });
                writer.writeLong(PacketKt.access$msecToSec(expiration));
                Long l = seq;
                if (l == null) break block0;
                Long l2 = l;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                writer.writeLong(it);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, Endpoint from2, Endpoint to2, long expiration, Long seq) {
            $this.encodeTo(writer, from2, to2, expiration, seq);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

