/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Peer;
import org.apache.tuweni.devp2p.PeerRoutingTable;
import org.apache.tuweni.kademlia.KademliaRoutingTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0096\u0002J\u0016\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0096\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\tH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/apache/tuweni/devp2p/DevP2PPeerRoutingTable;", "Lorg/apache/tuweni/devp2p/PeerRoutingTable;", "selfId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;)V", "idHashCache", "Lcom/google/common/cache/Cache;", "", "size", "", "getSize", "()I", "table", "Lorg/apache/tuweni/kademlia/KademliaRoutingTable;", "Lorg/apache/tuweni/devp2p/Peer;", "add", "node", "contains", "", "element", "containsAll", "elements", "", "evict", "hashForId", "id", "isEmpty", "iterator", "", "nearest", "", "targetId", "limit", "devp2p"})
public final class DevP2PPeerRoutingTable
implements PeerRoutingTable {
    private final Cache<SECP256K1.PublicKey, byte[]> idHashCache;
    private final KademliaRoutingTable<Peer> table;

    public int getSize() {
        return this.table.size();
    }

    public boolean contains(@NotNull Peer element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.table.contains((Object)element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return this.table.containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Peer> iterator() {
        return this.table.iterator();
    }

    @Override
    @NotNull
    public List<Peer> nearest(@NotNull SECP256K1.PublicKey targetId, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)targetId, (String)"targetId");
        return this.table.nearest(this.hashForId(targetId), limit);
    }

    @Override
    @Nullable
    public Peer add(@NotNull Peer node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        return (Peer)this.table.add((Object)node2);
    }

    @Override
    public boolean evict(@NotNull Peer node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        return this.table.evict((Object)node2);
    }

    private final byte[] hashForId(SECP256K1.PublicKey id) {
        Object object = this.idHashCache.get((Object)id, (Callable)new Callable<byte[]>(id){
            final /* synthetic */ SECP256K1.PublicKey $id;

            public final byte[] call() {
                return Hash.keccak256((byte[])this.$id.bytesArray());
            }
            {
                this.$id = publicKey;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"idHashCache.get(id) { keccak256(id.bytesArray()) }");
        return (byte[])object;
    }

    public DevP2PPeerRoutingTable(@NotNull SECP256K1.PublicKey selfId) {
        Intrinsics.checkParameterIsNotNull((Object)selfId, (String)"selfId");
        Cache cache = CacheBuilder.newBuilder().maximumSize(4112L).weakKeys().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder.newBuilder(\u2026 * 16).weakKeys().build()");
        this.idHashCache = cache;
        this.table = new KademliaRoutingTable(this.hashForId(selfId), 16, 0, (Function1)new Function1<Peer, byte[]>(this){
            final /* synthetic */ DevP2PPeerRoutingTable this$0;

            @NotNull
            public final byte[] invoke(@NotNull Peer p) {
                Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                return DevP2PPeerRoutingTable.access$hashForId(this.this$0, p.getNodeId());
            }
            {
                this.this$0 = devP2PPeerRoutingTable;
                super(1);
            }
        }, 4, null);
    }

    public static final /* synthetic */ byte[] access$hashForId(DevP2PPeerRoutingTable $this, SECP256K1.PublicKey id) {
        return $this.hashForId(id);
    }

    @Override
    public boolean add(Peer peer) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Peer> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

