/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.DelegatingMutableBytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.bytes.MutableBytes32;

final class DelegatingMutableBytes32
extends DelegatingMutableBytes
implements MutableBytes32 {
    private DelegatingMutableBytes32(MutableBytes delegate) {
        super(delegate);
    }

    static MutableBytes32 delegateTo(MutableBytes value) {
        Preconditions.checkArgument((value.size() == 32 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)32, (int)value.size());
        return new DelegatingMutableBytes32(value);
    }

    @Override
    public Bytes32 copy() {
        return Bytes32.wrap(this.delegate.toArray());
    }

    @Override
    public MutableBytes32 mutableCopy() {
        return MutableBytes32.wrap(this.delegate.toArray());
    }
}

