/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.tuweni.bytes.ArrayWrappingBytes32;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.BytesValues;
import org.apache.tuweni.bytes.DelegatingBytes32;
import org.apache.tuweni.bytes.MutableBytes32;

public interface Bytes32
extends Bytes {
    public static final int SIZE = 32;
    public static final Bytes32 ZERO = Bytes32.wrap(new byte[32]);

    public static Bytes32 wrap(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((bytes.length == 32 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)32, (int)bytes.length);
        return Bytes32.wrap(bytes, 0);
    }

    public static Bytes32 wrap(byte[] bytes, int offset) {
        Preconditions.checkNotNull((Object)bytes);
        return new ArrayWrappingBytes32(bytes, offset);
    }

    public static Bytes32 wrap(Bytes value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        return DelegatingBytes32.delegateTo(value);
    }

    public static Bytes32 wrap(Bytes value, int offset) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        Bytes slice = value.slice(offset, 32);
        if (slice instanceof Bytes32) {
            return (Bytes32)slice;
        }
        return DelegatingBytes32.delegateTo(slice);
    }

    public static Bytes32 leftPad(Bytes value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        Preconditions.checkArgument((value.size() <= 32 ? 1 : 0) != 0, (String)"Expected at most %s bytes but got %s", (int)32, (int)value.size());
        MutableBytes32 result = MutableBytes32.create();
        value.copyTo(result, 32 - value.size());
        return result;
    }

    public static Bytes32 rightPad(Bytes value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        Preconditions.checkArgument((value.size() <= 32 ? 1 : 0) != 0, (String)"Expected at most %s bytes but got %s", (int)32, (int)value.size());
        MutableBytes32 result = MutableBytes32.create();
        value.copyTo(result, 0);
        return result;
    }

    public static Bytes32 fromHexStringLenient(CharSequence str) {
        Preconditions.checkNotNull((Object)str);
        return Bytes32.wrap(BytesValues.fromRawHexString(str, 32, true));
    }

    public static Bytes32 fromHexString(CharSequence str) {
        Preconditions.checkNotNull((Object)str);
        return Bytes32.wrap(BytesValues.fromRawHexString(str, 32, false));
    }

    public static Bytes32 random() {
        return Bytes32.random(new SecureRandom());
    }

    public static Bytes32 random(Random generator) {
        byte[] array = new byte[32];
        generator.nextBytes(array);
        return Bytes32.wrap(array);
    }

    public static Bytes32 fromHexStringStrict(CharSequence str) {
        Preconditions.checkNotNull((Object)str);
        return Bytes32.wrap(BytesValues.fromRawHexString(str, -1, false));
    }

    @Override
    default public int size() {
        return 32;
    }

    default public Bytes32 and(Bytes32 other) {
        return this.and(other, MutableBytes32.create());
    }

    default public Bytes32 or(Bytes32 other) {
        return this.or(other, MutableBytes32.create());
    }

    default public Bytes32 xor(Bytes32 other) {
        return this.xor(other, MutableBytes32.create());
    }

    @Override
    default public Bytes32 not() {
        return this.not(MutableBytes32.create());
    }

    @Override
    default public Bytes32 shiftRight(int distance) {
        return this.shiftRight(distance, MutableBytes32.create());
    }

    @Override
    default public Bytes32 shiftLeft(int distance) {
        return this.shiftLeft(distance, MutableBytes32.create());
    }

    @Override
    public Bytes32 copy();

    @Override
    public MutableBytes32 mutableCopy();
}

