/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.Bytes48;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes48;
import org.apache.tuweni.bytes.MutableBytes48;

final class ArrayWrappingBytes48
extends ArrayWrappingBytes
implements Bytes48 {
    ArrayWrappingBytes48(byte[] bytes) {
        this(ArrayWrappingBytes48.checkLength(bytes), 0);
    }

    ArrayWrappingBytes48(byte[] bytes, int offset) {
        super(ArrayWrappingBytes48.checkLength(bytes, offset), offset, 48);
    }

    private static byte[] checkLength(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 48 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)48, (int)bytes.length);
        return bytes;
    }

    private static byte[] checkLength(byte[] bytes, int offset) {
        Preconditions.checkArgument((bytes.length - offset >= 48 ? 1 : 0) != 0, (String)"Expected at least %s bytes from offset %s but got only %s", (Object)48, (Object)offset, (Object)(bytes.length - offset));
        return bytes;
    }

    @Override
    public Bytes48 copy() {
        if (this.offset == 0 && this.length == this.bytes.length) {
            return this;
        }
        return new ArrayWrappingBytes48(this.toArray());
    }

    @Override
    public MutableBytes48 mutableCopy() {
        return new MutableArrayWrappingBytes48(this.toArray());
    }
}

