/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSet;
import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;

public class TableDataSet
extends DataSet {
    private String where = null;
    private String order = null;
    private String other = null;
    private boolean refreshOnSave = false;

    public TableDataSet() throws SQLException, DataSetException {
    }

    public TableDataSet(Connection conn, String tableName) throws SQLException, DataSetException {
        super(conn, tableName);
    }

    public TableDataSet(Connection conn, Schema schema, KeyDef keydef) throws SQLException, DataSetException {
        super(conn, schema, keydef);
    }

    public TableDataSet(Connection conn, String tableName, KeyDef keydef) throws SQLException, DataSetException {
        super(conn, tableName, keydef);
    }

    public TableDataSet(Connection conn, String tableName, String columns) throws SQLException, DataSetException {
        super(conn, tableName, columns);
    }

    public TableDataSet(Connection conn, String tableName, String columns, KeyDef keydef) throws SQLException, DataSetException {
        super(conn, tableName, columns, keydef);
    }

    public DataSet fetchRecords(int start, int max) throws SQLException, DataSetException {
        this.buildSelectString();
        return super.fetchRecords(start, max);
    }

    public int save() throws SQLException, DataSetException {
        return this.save(this.connection(), false);
    }

    public int save(boolean intransaction) throws SQLException, DataSetException {
        return this.save(this.connection(), intransaction);
    }

    public int save(Connection conn, boolean intransaction) throws SQLException, DataSetException {
        int j = 0;
        Enumeration e = this.records.elements();
        while (e.hasMoreElements()) {
            Record rec = (Record)e.nextElement();
            rec.save(conn);
            ++j;
        }
        this.removeDeletedRecords();
        return j;
    }

    public void removeDeletedRecords() throws DataSetException {
        Enumeration e = this.records.elements();
        while (e.hasMoreElements()) {
            Record rec = (Record)e.nextElement();
            if (!rec.isAZombie()) continue;
            this.removeRecord(rec);
        }
    }

    public TableDataSet where(String where) throws DataSetException {
        if (where == null) {
            throw new DataSetException("null not allowed for where clause");
        }
        this.where = where;
        return this;
    }

    String getWhere() {
        return this.where;
    }

    public TableDataSet order(String order) throws DataSetException {
        if (order == null) {
            throw new DataSetException("null not allowed for order clause");
        }
        this.order = order;
        return this;
    }

    String getOrder() {
        return this.order;
    }

    public TableDataSet other(String other) throws DataSetException {
        if (other == null) {
            throw new DataSetException("null not allowed for other clause");
        }
        this.other = other;
        return this;
    }

    String getOther() {
        return this.other;
    }

    public void refresh(Connection conn) throws SQLException, DataSetException {
        Enumeration e = this.records.elements();
        while (e.hasMoreElements()) {
            Record rec = (Record)e.nextElement();
            rec.refresh(conn);
        }
    }

    public void setRefreshOnSave(boolean val) {
        this.refreshOnSave = val;
    }

    public boolean refreshOnSave() {
        return this.refreshOnSave;
    }

    public TableDataSet tableQualifier(String tq) {
        this.schema().appendTableName(tq);
        return this;
    }

    public String getSelectString() throws DataSetException {
        this.buildSelectString();
        return this.selectString.toString();
    }

    private void buildSelectString() throws DataSetException {
        if (this.selectString == null) {
            this.selectString = new StringBuffer(256);
        } else {
            this.selectString.setLength(0);
        }
        this.selectString.append("SELECT ");
        this.selectString.append(this.schema().attributes());
        this.selectString.append(" FROM ");
        this.selectString.append(this.schema().tableName());
        if (this.where != null && this.where.length() > 0) {
            this.selectString.append(" WHERE " + this.where);
        }
        if (this.order != null && this.order.length() > 0) {
            this.selectString.append(" ORDER BY " + this.order);
        }
        if (this.other != null && this.other.length() > 0) {
            this.selectString.append(this.other);
        }
    }
}

