/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.Column;
import com.workingdogs.village.DataSetException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class Schema {
    private String tableName = "";
    private String columnsAttribute = null;
    private int numberOfColumns = 0;
    private Column[] columns;
    private Map columnNumberByName;
    private static final Hashtable schemaCache = new Hashtable();
    private Hashtable tableHash = null;
    private boolean singleTable = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initSchemas(Connection conn) throws SQLException {
        ResultSet allCol = null;
        try {
            DatabaseMetaData databaseMetaData = conn.getMetaData();
            String connURL = databaseMetaData.getURL();
            allCol = databaseMetaData.getColumns(conn.getCatalog(), null, null, null);
            while (true) {
                Schema schema = new Schema();
                schema.setAttributes("*");
                schema.singleTable = true;
                schema.populate(allCol);
                if (schema.numberOfColumns <= 0) return;
                String keyValue = connURL + schema.tableName;
                Hashtable hashtable = schemaCache;
                synchronized (hashtable) {
                    schemaCache.put(keyValue, schema);
                }
            }
        }
        finally {
            if (allCol != null) {
                try {
                    allCol.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public Schema schema(Connection conn, String tableName) throws SQLException, DataSetException {
        return this.schema(conn, tableName, "*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema schema(Connection conn, String tableName, String columnsAttribute) throws SQLException, DataSetException {
        if (columnsAttribute == null) {
            columnsAttribute = "*";
        }
        Statement stmt = null;
        try {
            Schema tableSchema = null;
            String keyValue = conn.getMetaData().getURL() + tableName;
            Object object = schemaCache;
            synchronized (object) {
                tableSchema = (Schema)schemaCache.get(keyValue);
                if (tableSchema == null) {
                    String sql = "SELECT " + columnsAttribute + " FROM " + tableName + " WHERE 1 = -1";
                    stmt = conn.prepareStatement(sql);
                    if (stmt != null) {
                        stmt.executeQuery();
                        tableSchema = this;
                        tableSchema.setTableName(tableName);
                        tableSchema.setAttributes(columnsAttribute);
                        tableSchema.populate(stmt.getMetaData(), tableName, null);
                        schemaCache.put(keyValue, tableSchema);
                    } else {
                        throw new DataSetException("Couldn't retrieve schema for " + tableName);
                    }
                }
            }
            object = tableSchema;
            return object;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    void appendTableName(String app) {
        this.tableName = this.tableName + " " + app;
    }

    public String attributes() {
        return this.columnsAttribute;
    }

    public Column column(int i) throws DataSetException {
        if (i == 0) {
            throw new DataSetException("Columns are 1 based");
        }
        if (i > this.numberOfColumns) {
            throw new DataSetException("There are only " + this.numberOfColumns() + " available!");
        }
        try {
            return this.columns[i];
        }
        catch (Exception e) {
            throw new DataSetException("Column number: " + this.numberOfColumns() + " does not exist!");
        }
    }

    public Column column(String colName) throws DataSetException {
        return this.column(this.index(colName));
    }

    public Column getColumn(String colName) throws DataSetException {
        int dot = colName.indexOf(46);
        if (dot > 0) {
            String table = colName.substring(0, dot);
            String col = colName.substring(dot + 1);
            return this.getColumn(table, col);
        }
        return this.column(this.index(colName));
    }

    public Column getColumn(String tableName, String colName) throws DataSetException {
        return (Column)((Hashtable)this.tableHash.get(tableName)).get(colName);
    }

    Column[] getColumns() {
        return this.columns;
    }

    public String getTableName() throws DataSetException {
        if (this.singleTable) {
            return this.tableName;
        }
        throw new DataSetException("This schema represents several tables.");
    }

    public String[] getAllTableNames() {
        Enumeration e = this.tableHash.keys();
        String[] tableNames = new String[this.tableHash.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            tableNames[i] = (String)e.nextElement();
            ++i;
        }
        return tableNames;
    }

    public int index(String colName) throws DataSetException {
        Integer position = (Integer)this.columnNumberByName.get(colName);
        if (position != null) {
            return position;
        }
        throw new DataSetException("Column name: " + colName + " does not exist!");
    }

    public int index(String tableName, String colName) throws DataSetException {
        return this.index(tableName + "." + colName);
    }

    public boolean isSingleTable() {
        return this.singleTable;
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populate(ResultSetMetaData meta, String tableName, Connection conn) throws SQLException, DataSetException {
        int i;
        this.numberOfColumns = meta.getColumnCount();
        this.columns = new Column[this.numberOfColumns() + 1];
        this.columnNumberByName = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        String connURL = conn != null ? conn.getMetaData().getURL() : null;
        for (i = 1; i <= this.numberOfColumns(); ++i) {
            String metaColumnName = meta.getColumnName(i);
            String metaTableName = null;
            try {
                metaTableName = meta.getTableName(i);
                if (metaTableName == null || metaTableName.equals("")) {
                    metaTableName = tableName != null ? tableName : "";
                }
            }
            catch (RuntimeException e) {
                metaTableName = tableName != null ? tableName : "";
            }
            Column col = null;
            if (metaTableName.length() > 0 && connURL != null) {
                Schema tableSchema = null;
                Hashtable hashtable = schemaCache;
                synchronized (hashtable) {
                    tableSchema = (Schema)schemaCache.get(connURL + metaTableName);
                }
                if (tableSchema != null) {
                    try {
                        col = tableSchema.column(metaColumnName);
                    }
                    catch (DataSetException e) {
                        // empty catch block
                    }
                }
            }
            if (col == null) {
                col = new Column();
                col.populate(meta, i, metaTableName, metaColumnName);
            }
            this.columns[i] = col;
            Integer position = new Integer(i);
            this.columnNumberByName.put(metaColumnName, position);
            this.columnNumberByName.put(metaTableName + "." + metaColumnName, position);
            if (i <= 1 || col.getTableName().equalsIgnoreCase(this.columns[i - 1].getTableName())) continue;
            this.singleTable = false;
        }
        if (this.singleTable) {
            if (tableName != null && tableName.length() > 0) {
                this.setTableName(tableName);
            } else {
                try {
                    this.setTableName(this.columns[1].getTableName());
                }
                catch (Exception e) {
                    this.setTableName("");
                }
            }
        } else {
            this.tableHash = new Hashtable((int)(1.25 * (double)this.numberOfColumns + 1.0));
            for (i = 1; i <= this.numberOfColumns(); ++i) {
                Hashtable<String, Column> columnHash;
                if (this.tableHash.containsKey(this.columns[i].getTableName())) {
                    columnHash = (Hashtable<String, Column>)this.tableHash.get(this.columns[i].getTableName());
                } else {
                    columnHash = new Hashtable<String, Column>((int)(1.25 * (double)this.numberOfColumns + 1.0));
                    this.tableHash.put(this.columns[i].getTableName(), columnHash);
                }
                columnHash.put(this.columns[i].name(), this.columns[i]);
            }
        }
    }

    void populate(ResultSet dbMeta) throws SQLException {
        ArrayList<Column> cols = new ArrayList<Column>();
        String tableName = null;
        this.columnNumberByName = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        while (dbMeta.next()) {
            if (tableName == null) {
                tableName = dbMeta.getString(3);
                this.setTableName(tableName);
            } else if (!tableName.equals(dbMeta.getString(3))) {
                dbMeta.previous();
                break;
            }
            Column c = new Column();
            c.populate(tableName, dbMeta.getString(4), dbMeta.getString(6), dbMeta.getInt(5), dbMeta.getInt(11) == 1);
            cols.add(c);
            Integer position = new Integer(dbMeta.getInt(17));
            this.columnNumberByName.put(c.name(), position);
            this.columnNumberByName.put(tableName + "." + c.name(), position);
        }
        if (!cols.isEmpty()) {
            this.numberOfColumns = cols.size();
            this.columns = new Column[this.numberOfColumns() + 1];
            int i = 1;
            Iterator col = cols.iterator();
            while (col.hasNext()) {
                this.columns[i++] = (Column)col.next();
            }
        }
    }

    void setAttributes(String attributes) {
        this.columnsAttribute = attributes;
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String tableName() throws DataSetException {
        return this.getTableName();
    }

    public String toString() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        out.print('{');
        for (int i = 1; i <= this.numberOfColumns; ++i) {
            out.print('\'');
            if (!this.singleTable) {
                out.print(this.columns[i].getTableName() + '.');
            }
            out.print(this.columns[i].name() + '\'');
            if (i >= this.numberOfColumns) continue;
            out.print(',');
        }
        out.print('}');
        out.flush();
        return bout.toString();
    }
}

