/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSet;
import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Schema;
import com.workingdogs.village.TableDataSet;
import com.workingdogs.village.Value;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class Record {
    private Value[] values;
    private boolean[] isClean;
    private DataSet parentDataSet;
    private int numberOfColumns;
    private int saveType = 0;
    private Schema schema;

    public Record() {
    }

    public Record(DataSet ds) throws DataSetException, SQLException {
        this.setParentDataSet(ds);
        this.initializeRecord();
        this.createValues(this.dataset().resultSet());
    }

    Record(DataSet ds, boolean addRecord) throws DataSetException, SQLException {
        this.setParentDataSet(ds);
        this.initializeRecord();
        this.createValues(null);
    }

    private void initializeRecord() throws DataSetException {
        this.schema = this.dataset().schema();
        this.numberOfColumns = this.schema.numberOfColumns();
        this.values = new Value[this.size() + 1];
        this.isClean = new boolean[this.size() + 1];
        this.setSaveType(11);
        for (int i = 1; i <= this.size(); ++i) {
            this.markValueClean(i);
            this.values[i] = null;
        }
    }

    private void createValues(ResultSet rs) throws DataSetException, SQLException {
        for (int i = 1; i <= this.size(); ++i) {
            Value val;
            this.values[i] = val = new Value(rs, i, this.schema().column(i).typeEnum());
        }
    }

    public int save() throws DataSetException, SQLException {
        return this.save(this.dataset().connection());
    }

    public int save(Connection connection) throws DataSetException, SQLException {
        int returnValue = 0;
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot save a QueryDataSet. Please use a TableDataSet instead.");
        }
        if (!this.needsToBeSaved()) {
            return returnValue;
        }
        if (this.toBeSavedWithInsert()) {
            returnValue = this.saveWithInsert(connection);
        } else if (this.toBeSavedWithUpdate()) {
            returnValue = this.saveWithUpdate(connection);
        } else if (this.toBeSavedWithDelete()) {
            returnValue = this.saveWithDelete(connection);
        }
        return returnValue;
    }

    private int saveWithDelete(Connection connection) throws DataSetException, SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(this.getSaveString());
            int ps = 1;
            for (int i = 1; i <= this.dataset().keydef().size(); ++i) {
                Value val = this.getValue(this.dataset().keydef().getAttrib(i));
                val.setPreparedStatementValue(stmt, ps++);
            }
            int ret = stmt.executeUpdate();
            this.setSaveType(1);
            if (ret > 1) {
                throw new SQLException("There were " + ret + " rows deleted with this records key value.");
            }
            int n = ret;
            return n;
        }
        catch (SQLException e1) {
            throw e1;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private int saveWithUpdate(Connection connection) throws DataSetException, SQLException {
        PreparedStatement stmt = null;
        try {
            Value val;
            int i;
            stmt = connection.prepareStatement(this.getSaveString());
            int ps = 1;
            for (i = 1; i <= this.size(); ++i) {
                val = this.getValue(i);
                if (this.valueIsClean(i) || this.schema().column(i).readOnly()) continue;
                val.setPreparedStatementValue(stmt, ps++);
            }
            for (i = 1; i <= this.dataset().keydef().size(); ++i) {
                val = this.getValue(this.dataset().keydef().getAttrib(i));
                val.setPreparedStatementValue(stmt, ps++);
            }
            int ret = stmt.executeUpdate();
            if (((TableDataSet)this.dataset()).refreshOnSave()) {
                this.refresh(this.dataset().connection());
            } else {
                this.markRecordClean();
            }
            this.setSaveType(10);
            if (ret > 1) {
                throw new SQLException("There were " + ret + " rows updated with this records key value.");
            }
            int n = ret;
            return n;
        }
        catch (SQLException e1) {
            throw e1;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private int saveWithInsert(Connection connection) throws DataSetException, SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(this.getSaveString());
            int ps = 1;
            for (int i = 1; i <= this.size(); ++i) {
                Value val = this.getValue(i);
                if (this.valueIsClean(i) || this.schema().column(i).readOnly()) continue;
                val.setPreparedStatementValue(stmt, ps++);
            }
            int ret = stmt.executeUpdate();
            if (((TableDataSet)this.dataset()).refreshOnSave()) {
                this.refresh(this.dataset().connection());
            } else {
                this.markRecordClean();
            }
            this.setSaveType(8);
            if (ret > 1) {
                throw new SQLException("There were " + ret + " rows inserted with this records key value.");
            }
            int n = ret;
            return n;
        }
        catch (SQLException e1) {
            throw e1;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private String getUpdateSaveString() throws DataSetException {
        int i;
        KeyDef kd = this.dataset().keydef();
        if (kd == null || kd.size() == 0) {
            throw new DataSetException("You must specify KeyDef attributes for this TableDataSet in order to create a Record for update.");
        }
        if (this.recordIsClean()) {
            throw new DataSetException("You must Record.setValue() on a column before doing an update.");
        }
        StringBuffer iss1 = new StringBuffer(256);
        StringBuffer iss2 = new StringBuffer(256);
        boolean comma = false;
        for (i = 1; i <= this.size(); ++i) {
            if (this.valueIsClean(i) || this.schema().column(i).readOnly()) continue;
            if (!comma) {
                iss1.append(this.schema().column(i).name());
                iss1.append(" = ?");
                comma = true;
                continue;
            }
            iss1.append(", ");
            iss1.append(this.schema().column(i).name());
            iss1.append(" = ?");
        }
        comma = false;
        for (i = 1; i <= kd.size(); ++i) {
            String attrib = kd.getAttrib(i);
            if (!this.valueIsClean(this.schema().index(attrib))) {
                throw new DataSetException("The value for column '" + attrib + "' is a key value and cannot be updated.");
            }
            if (!comma) {
                iss2.append(attrib);
                iss2.append(" = ?");
                comma = true;
                continue;
            }
            iss2.append(" AND ");
            iss2.append(attrib);
            iss2.append(" = ?");
        }
        return "UPDATE " + this.schema().tableName() + " SET " + iss1.toString() + " WHERE " + iss2.toString();
    }

    private String getDeleteSaveString() throws DataSetException {
        KeyDef kd = this.dataset().keydef();
        if (kd == null || kd.size() == 0) {
            throw new DataSetException("You must specify KeyDef attributes for this TableDataSet in order to delete a Record.");
        }
        StringBuffer iss1 = new StringBuffer(256);
        boolean comma = false;
        for (int i = 1; i <= kd.size(); ++i) {
            if (!comma) {
                iss1.append(kd.getAttrib(i));
                iss1.append(" = ?");
                comma = true;
                continue;
            }
            iss1.append(" AND ");
            iss1.append(kd.getAttrib(i));
            iss1.append(" = ? ");
        }
        return "DELETE FROM " + this.schema().tableName() + " WHERE " + iss1.toString();
    }

    private String getInsertSaveString() throws DataSetException {
        StringBuffer iss1 = new StringBuffer(256);
        StringBuffer iss2 = new StringBuffer(256);
        boolean comma = false;
        for (int i = 1; i <= this.size(); ++i) {
            if (this.valueIsClean(i) || this.schema().column(i).readOnly()) continue;
            if (!comma) {
                iss1.append(this.schema().column(i).name());
                iss2.append("?");
                comma = true;
                continue;
            }
            iss1.append(", " + this.schema().column(i).name());
            iss2.append(", ?");
        }
        return "INSERT INTO " + this.schema().tableName() + " ( " + iss1.toString() + " ) VALUES ( " + iss2.toString() + " )";
    }

    public String getSaveString() throws DataSetException {
        if (this.toBeSavedWithInsert()) {
            return this.getInsertSaveString();
        }
        if (this.toBeSavedWithUpdate()) {
            return this.getUpdateSaveString();
        }
        if (this.toBeSavedWithDelete()) {
            return this.getDeleteSaveString();
        }
        throw new DataSetException("Not able to return save string: " + this.saveType);
    }

    public Value getValue(int i) throws DataSetException {
        if (i == 0) {
            throw new DataSetException("Values are 1 based!");
        }
        if (i > this.size()) {
            throw new DataSetException("Only " + this.size() + " columns exist!");
        }
        if (this.values[i] == null) {
            throw new DataSetException("No values for the requested column!");
        }
        return this.values[i];
    }

    public Value getValue(String columnName) throws DataSetException {
        return this.getValue(this.schema().index(columnName));
    }

    public int size() {
        return this.numberOfColumns;
    }

    public boolean toBeSavedWithInsert() {
        return this.saveType == 4;
    }

    public boolean toBeSavedWithUpdate() {
        return this.saveType == 3;
    }

    public boolean toBeSavedWithDelete() {
        return this.saveType == 2;
    }

    public void markRecordClean() throws DataSetException {
        for (int i = 1; i <= this.size(); ++i) {
            this.markValueClean(i);
        }
    }

    public void markForInsert() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for insert");
        }
        this.setSaveType(4);
    }

    public void markForUpdate() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for update");
        }
        this.setSaveType(3);
    }

    public Record markToBeDeleted() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for deletion");
        }
        this.setSaveType(2);
        return this;
    }

    public Record unmarkToBeDeleted() throws DataSetException {
        if (this.saveType == 1) {
            throw new DataSetException("This record has already been deleted!");
        }
        this.setSaveType(11);
        return this;
    }

    public void markValueClean(int pos) throws DataSetException {
        if (pos == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (pos > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.isClean[pos] = true;
    }

    public void markValueClean(String columnName) throws DataSetException {
        this.markValueClean(this.schema().index(columnName));
    }

    public void markValueDirty(int pos) throws DataSetException {
        if (pos == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (pos > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.isClean[pos] = false;
    }

    public void markValueDirty(String columnName) throws DataSetException {
        this.markValueDirty(this.schema().index(columnName));
    }

    void setSaveType(int type) {
        this.saveType = type;
    }

    int getSaveType() {
        return this.saveType;
    }

    public Record setValue(int pos, BigDecimal value) throws DataSetException {
        this.values[pos].setValue(value);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, boolean value) throws DataSetException {
        this.values[pos].setValue(new Boolean(value));
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, byte[] value) throws DataSetException {
        this.values[pos].setValue(value);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, java.util.Date value) throws DataSetException {
        this.values[pos].setValue(value);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, Date value) throws DataSetException {
        this.values[pos].setValue(value);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, double value) throws DataSetException {
        this.values[pos].setValue(new Double(value));
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, float value) throws DataSetException {
        this.values[pos].setValue(new Float(value));
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, int value) throws DataSetException {
        this.values[pos].setValue(new Integer(value));
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, long value) throws DataSetException {
        this.values[pos].setValue(new Long(value));
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, String value) throws DataSetException {
        this.values[pos].setValue(value);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, Time value) throws DataSetException {
        this.values[pos].setValue(value);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, Timestamp value) throws DataSetException {
        this.values[pos].setValue(value);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(int pos, Value value) throws DataSetException {
        this.values[pos].setValue(value.getValue());
        this.markValueDirty(pos);
        return this;
    }

    public Record setValue(String columnName, BigDecimal value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, boolean value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, byte[] value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, java.util.Date value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, Date value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, double value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, float value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, int value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, long value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, String value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, Time value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, Timestamp value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValue(String columnName, Value value) throws DataSetException {
        this.setValue(this.schema().index(columnName), value);
        return this;
    }

    public Record setValueNull(int pos) throws DataSetException {
        if (pos == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (pos > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.values[pos].setValue(null);
        this.markValueDirty(pos);
        return this;
    }

    public Record setValueNull(String columnName) throws DataSetException {
        if (columnName == null || columnName.length() == 0) {
            throw new DataSetException("You must specify a column name!");
        }
        this.setValueNull(this.schema().index(columnName));
        return this;
    }

    public boolean isAZombie() {
        return this.saveType == 1;
    }

    public boolean needsToBeSaved() {
        return !this.isAZombie() || !this.recordIsClean() || this.toBeSavedWithUpdate() || this.toBeSavedWithDelete() || this.toBeSavedWithInsert();
    }

    public boolean valueIsClean(int i) {
        return this.isClean[i];
    }

    boolean valueIsClean(String column) throws DataSetException {
        return this.isClean[this.getValue(column).columnNumber()];
    }

    public boolean recordIsClean() {
        for (int i = 1; i <= this.size(); ++i) {
            if (this.valueIsClean(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Connection connection) throws DataSetException, SQLException {
        if (this.toBeSavedWithDelete()) {
            return;
        }
        if (this.toBeSavedWithInsert()) {
            throw new DataSetException("There is no way to refresh a record which has been created with addRecord().");
        }
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You can only perform a refresh on Records created with a TableDataSet.");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.prepareStatement(this.getRefreshQueryString());
            int ps = 1;
            for (int i = 1; i <= this.dataset().keydef().size(); ++i) {
                Value val = this.getValue(this.dataset().keydef().getAttrib(i));
                if (val.isNull()) {
                    throw new DataSetException("You cannot execute an update with a null value for a KeyDef.");
                }
                val.setPreparedStatementValue(stmt, ps++);
            }
            rs = stmt.executeQuery();
            rs.next();
            this.initializeRecord();
            this.createValues(rs);
        }
        finally {
            SQLException sqlEx = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                sqlEx = e2;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                sqlEx = e2;
            }
            if (sqlEx != null) {
                throw sqlEx;
            }
        }
    }

    public String getRefreshQueryString() throws DataSetException {
        int i;
        if (this.dataset().keydef() == null || this.dataset().keydef().size() == 0) {
            throw new DataSetException("You can only perform a getRefreshQueryString on a TableDataSet that was created with a KeyDef.");
        }
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You can only perform a getRefreshQueryString on Records created with a TableDataSet.");
        }
        StringBuffer iss1 = new StringBuffer(256);
        StringBuffer iss2 = new StringBuffer(256);
        boolean comma = false;
        for (i = 1; i <= this.size(); ++i) {
            if (!comma) {
                iss1.append(this.schema().column(i).name());
                comma = true;
                continue;
            }
            iss1.append(", ");
            iss1.append(this.schema().column(i).name());
        }
        comma = false;
        for (i = 1; i <= this.dataset().keydef().size(); ++i) {
            String attrib = this.dataset().keydef().getAttrib(i);
            if (!this.valueIsClean(attrib)) {
                throw new DataSetException("You cannot do a refresh from the database if the value for a KeyDef column has been changed with a Record.setValue().");
            }
            if (!comma) {
                iss2.append(attrib);
                iss2.append(" = ?");
                comma = true;
                continue;
            }
            iss2.append(" AND ");
            iss2.append(attrib);
            iss2.append(" = ?");
        }
        return "SELECT " + iss1.toString() + " FROM " + this.schema().tableName() + " WHERE " + iss2.toString();
    }

    public void saveWithoutStatusUpdate() throws DataSetException {
        throw new DataSetException("Record.saveWithoutStatusUpdate() is not yet implemented.");
    }

    public Schema schema() throws DataSetException {
        if (this.dataset() != null) {
            return this.schema;
        }
        throw new DataSetException("Internal Error: Record DataSet is null");
    }

    public DataSet dataset() {
        return this.parentDataSet;
    }

    void setParentDataSet(DataSet ds) {
        this.parentDataSet = ds;
    }

    public String asFormattedString(String valueseparator, int[] maxwidths) throws DataSetException {
        throw new DataSetException("Not yet implemented!");
    }

    public String toString() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(bout);
            out.print("{");
            for (int i = 1; i <= this.size(); ++i) {
                out.print("'" + this.getValue(i).asString() + "'");
                if (i >= this.size()) continue;
                out.print(',');
            }
            out.print("}");
            out.flush();
            return bout.toString();
        }
        catch (DataSetException e) {
            return "";
        }
    }
}

