/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import com.workingdogs.village.TableDataSet;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public abstract class DataSet {
    protected static final int ALL_RECORDS = -1;
    protected Schema schema;
    protected Vector records = null;
    protected Connection conn;
    private boolean allRecordsRetrieved = false;
    private int recordRetrievedCount = 0;
    private int lastFetchSize = 0;
    private String columns;
    protected StringBuffer selectString;
    private KeyDef keyDefValue;
    protected ResultSet resultSet;
    protected Statement stmt;

    public DataSet() throws DataSetException, SQLException {
    }

    DataSet(Connection conn, String tableName) throws DataSetException, SQLException {
        this.conn = conn;
        this.columns = "*";
        this.schema = new Schema().schema(conn, tableName);
    }

    DataSet(Connection conn, Schema schema, KeyDef keydef) throws DataSetException, SQLException {
        if (conn == null) {
            throw new SQLException("Database connection could not be established!");
        }
        if (schema == null) {
            throw new DataSetException("You need to specify a valid schema!");
        }
        if (keydef == null) {
            throw new DataSetException("You need to specify a valid KeyDef!");
        }
        this.conn = conn;
        this.schema = schema;
        this.columns = "*";
        this.keyDefValue = keydef;
    }

    DataSet(Connection conn, String tableName, KeyDef keydef) throws SQLException, DataSetException {
        this.conn = conn;
        this.keyDefValue = keydef;
        this.columns = "*";
        this.schema = new Schema().schema(conn, tableName);
    }

    DataSet(Connection conn, String tableName, String columns) throws SQLException, DataSetException {
        this.conn = conn;
        this.columns = columns;
        this.schema = new Schema().schema(conn, tableName, columns);
    }

    DataSet(Connection conn, String tableName, String columns, KeyDef keyDef) throws SQLException, DataSetException {
        this.conn = conn;
        this.columns = columns;
        this.keyDefValue = keyDef;
        this.schema = new Schema().schema(conn, tableName, columns);
    }

    public ResultSet resultSet() throws SQLException, DataSetException {
        if (this.resultSet == null) {
            throw new DataSetException("ResultSet is null.");
        }
        return this.resultSet;
    }

    public Record addRecord() throws DataSetException, SQLException {
        return this.addRecord(this);
    }

    public Record addRecord(DataSet ds) throws DataSetException, SQLException {
        if (ds instanceof QueryDataSet) {
            throw new DataSetException("You cannot add records to a QueryDataSet.");
        }
        if (this.records == null) {
            this.records = new Vector(10);
        }
        Record rec = new Record(ds, true);
        rec.markForInsert();
        this.records.addElement(rec);
        return rec;
    }

    public boolean allRecordsRetrieved() {
        return this.allRecordsRetrieved;
    }

    void setAllRecordsRetrieved(boolean set) {
        this.allRecordsRetrieved = set;
    }

    public Record removeRecord(Record rec) throws DataSetException {
        Record removeRec = null;
        try {
            int loc = this.records.indexOf(rec);
            removeRec = (Record)this.records.elementAt(loc);
            this.records.removeElementAt(loc);
        }
        catch (Exception e) {
            throw new DataSetException("Record could not be removed!");
        }
        return removeRec;
    }

    public DataSet clearRecords() {
        this.records.removeAllElements();
        this.records = null;
        return this;
    }

    public DataSet releaseRecords() {
        this.records = null;
        this.recordRetrievedCount = 0;
        this.lastFetchSize = 0;
        this.setAllRecordsRetrieved(false);
        return this;
    }

    public void close() throws SQLException, DataSetException {
        this.releaseRecords();
        this.schema = null;
        SQLException sqlEx = null;
        try {
            if (this.resultSet != null) {
                this.resultSet().close();
            }
        }
        catch (SQLException e) {
            sqlEx = e;
        }
        this.resultSet = null;
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException e) {
            sqlEx = e;
        }
        this.conn = null;
        if (sqlEx != null) {
            throw sqlEx;
        }
    }

    public DataSet reset() throws DataSetException, SQLException {
        if (this.resultSet() == null || !(this instanceof QueryDataSet)) {
            return this.releaseRecords();
        }
        throw new DataSetException("You cannot call reset() on a QueryDataSet.");
    }

    public Connection connection() throws SQLException {
        return this.conn;
    }

    public Schema schema() {
        return this.schema;
    }

    public Record getRecord(int pos) throws DataSetException {
        if (this.containsRecord(pos)) {
            Record rec = (Record)this.records.elementAt(pos);
            if (this instanceof TableDataSet) {
                rec.markForUpdate();
            }
            ++this.recordRetrievedCount;
            return rec;
        }
        throw new DataSetException("Record not found at index: " + pos);
    }

    Record findRecord(int pos) throws DataSetException {
        if (this.containsRecord(pos)) {
            return (Record)this.records.elementAt(pos);
        }
        throw new DataSetException("Record not found at index: " + pos);
    }

    public boolean containsRecord(int pos) {
        try {
            if (this.records.elementAt(pos) != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public DataSet fetchRecords() throws SQLException, DataSetException {
        return this.fetchRecords(-1);
    }

    public DataSet fetchRecords(int max) throws SQLException, DataSetException {
        return this.fetchRecords(0, max);
    }

    public DataSet fetchRecords(int start, int max) throws SQLException, DataSetException {
        if (max == 0) {
            throw new DataSetException("Max is 1 based and must be greater than 0!");
        }
        if (this.lastFetchSize() > 0 && this.records != null) {
            throw new DataSetException("You must call DataSet.clearRecords() before executing DataSet.fetchRecords() again!");
        }
        if (this.selectString == null) {
            this.selectString = new StringBuffer(256);
            this.selectString.append("SELECT ");
            this.selectString.append(this.schema().attributes());
            this.selectString.append(" FROM ");
            this.selectString.append(this.schema().tableName());
        }
        try {
            if (this.stmt == null && this.resultSet == null) {
                this.stmt = this.connection().createStatement();
                this.resultSet = this.stmt.executeQuery(this.selectString.toString());
            }
            if (this.resultSet != null) {
                this.records = this.records == null && max > 0 ? new Vector(max) : new Vector();
                int startCounter = 0;
                int fetchCount = 0;
                while (!this.allRecordsRetrieved() && fetchCount != max) {
                    if (this.resultSet.next()) {
                        if (startCounter >= start) {
                            Record rec = new Record(this);
                            this.records.addElement(rec);
                            ++fetchCount;
                            continue;
                        }
                        ++startCounter;
                        continue;
                    }
                    this.setAllRecordsRetrieved(true);
                    break;
                }
                this.lastFetchSize = fetchCount;
            }
        }
        catch (SQLException e) {
            if (this.stmt != null) {
                this.stmt.close();
            }
            throw new SQLException(e.getMessage());
        }
        return this;
    }

    public int lastFetchSize() {
        return this.lastFetchSize;
    }

    public KeyDef keydef() {
        return this.keyDefValue;
    }

    public String toString() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(bout);
            if (this.schema != null) {
                out.println(this.schema.toString());
            }
            for (int i = 0; i < this.size(); ++i) {
                out.println(this.findRecord(i));
            }
            out.flush();
            return bout.toString();
        }
        catch (DataSetException e) {
            return "{}";
        }
    }

    public String tableName() throws DataSetException {
        return this.schema().tableName();
    }

    public abstract String getSelectString() throws DataSetException;

    String getColumns() {
        return this.columns;
    }

    public int size() {
        if (this.records == null) {
            return 0;
        }
        return this.records.size();
    }
}

