/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class Column {
    private String name = "";
    private int columnType = -1;
    private String tableName = "";
    private boolean nullAllowed = false;
    private boolean readOnly = false;

    public void populate(ResultSetMetaData rsmd, int colNum, String tableName, String columnName) throws SQLException {
        this.name = columnName;
        this.tableName = tableName;
        this.columnType = rsmd.getColumnType(colNum);
        this.nullAllowed = rsmd.isNullable(colNum) == 1;
    }

    public void populate(String tableName, String columnName, String columnTypeName, int columnType, boolean isNullable) {
        this.name = columnName;
        this.tableName = tableName;
        this.columnType = columnType;
        this.nullAllowed = isNullable;
    }

    public String name() {
        return this.name;
    }

    public int typeEnum() {
        return this.columnType;
    }

    public boolean nullAllowed() {
        return this.nullAllowed;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public String type() {
        if (this.isBoolean()) {
            return "BOOLEAN";
        }
        if (this.isByte()) {
            return "BYTE";
        }
        if (this.isShort()) {
            return "SHORT";
        }
        if (this.isInt()) {
            return "INTEGER";
        }
        if (this.isLong()) {
            return "LONG";
        }
        if (this.isFloat()) {
            return "FLOAT";
        }
        if (this.isDouble()) {
            return "DOUBLE";
        }
        if (this.isBigDecimal()) {
            return "BIGDECIMAL";
        }
        if (this.isDate()) {
            return "DATE";
        }
        if (this.isTime()) {
            return "TIME";
        }
        if (this.isTimestamp()) {
            return "TIMESTAMP";
        }
        if (this.isString()) {
            return "STRING";
        }
        if (this.isBinary()) {
            return "BINARY";
        }
        if (this.isVarBinary()) {
            return "VARBINARY";
        }
        if (this.isLongVarBinary()) {
            return "LONGVARBINARY";
        }
        return "UNKNOWN TYPE: " + this.typeEnum();
    }

    public boolean isBoolean() {
        return this.typeEnum() == -7;
    }

    public boolean isBigDecimal() {
        return this.typeEnum() == 2 || this.typeEnum() == 3;
    }

    public boolean isBinary() {
        return this.typeEnum() == -2;
    }

    public boolean isByte() {
        return this.typeEnum() == -6;
    }

    public boolean isBytes() {
        return this.typeEnum() == -4 || this.typeEnum() == -3 || this.columnType == -2;
    }

    public boolean isDate() {
        return this.typeEnum() == 91;
    }

    public boolean isDouble() {
        return this.typeEnum() == 6 || this.typeEnum() == 8;
    }

    public boolean isFloat() {
        return this.typeEnum() == 7;
    }

    public boolean isInt() {
        return this.typeEnum() == 4;
    }

    public boolean isLong() {
        return this.typeEnum() == -5;
    }

    public boolean isShort() {
        return this.typeEnum() == 5;
    }

    public boolean isString() {
        return this.typeEnum() == -1 || this.typeEnum() == 12 || this.typeEnum() == 11;
    }

    public boolean isTime() {
        return this.typeEnum() == 92;
    }

    public boolean isTimestamp() {
        return this.typeEnum() == 93;
    }

    public boolean isVarBinary() {
        return this.typeEnum() == -3;
    }

    public boolean isLongVarBinary() {
        return this.typeEnum() == -4;
    }

    public String getTableName() {
        return this.tableName;
    }
}

