/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ziplock;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ClassLoaders {
    private static final boolean DONT_USE_GET_URLS = Boolean.getBoolean("xbean.finder.use.get-resources");
    private static final ClassLoader SYSTEM = ClassLoader.getSystemClassLoader();
    private static final boolean UNIX = !System.getProperty("os.name").toLowerCase().contains("win");

    public static Set<URL> findUrls(ClassLoader classLoader) throws IOException {
        if (classLoader == null || SYSTEM.getParent() != null && classLoader == SYSTEM.getParent()) {
            return Collections.emptySet();
        }
        HashSet<URL> urls = new HashSet<URL>();
        if (URLClassLoader.class.isInstance(classLoader) && !DONT_USE_GET_URLS) {
            if (!ClassLoaders.isSurefire(classLoader)) {
                for (Collection item : Arrays.asList(Arrays.asList(((URLClassLoader)URLClassLoader.class.cast(classLoader)).getURLs()), ClassLoaders.findUrls(classLoader.getParent()))) {
                    for (URL url : item) {
                        ClassLoaders.addIfNotSo(urls, url);
                    }
                }
            } else {
                for (URL url : ClassLoaders.fromClassPath()) {
                    urls.add(url);
                }
            }
        } else {
            for (URL url : ClassLoaders.findUrlFromResources(classLoader)) {
                urls.add(url);
            }
        }
        return urls;
    }

    private static void addIfNotSo(Set<URL> urls, URL url) {
        if (UNIX && ClassLoaders.isNative(url)) {
            return;
        }
        urls.add(url);
    }

    public static File toFile(URL url) {
        if ("jar".equals(url.getProtocol())) {
            try {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                if (separator == -1) {
                    return null;
                }
                return ClassLoaders.toFile(new URL(spec.substring(0, separator + 1)));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if ("file".equals(url.getProtocol())) {
            String path = ClassLoaders.decode(url.getFile());
            if (path.endsWith("!")) {
                path = path.substring(0, path.length() - 1);
            }
            return new File(path);
        }
        return null;
    }

    public static String decode(String fileName) {
        if (fileName.indexOf(37) == -1) {
            return fileName;
        }
        StringBuilder result = new StringBuilder(fileName.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < fileName.length()) {
            char c = fileName.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= fileName.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                    }
                    int d1 = Character.digit(fileName.charAt(i + 1), 16);
                    int d2 = Character.digit(fileName.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence (" + fileName.substring(i, i + 3) + ") at: " + String.valueOf(i));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < fileName.length() && fileName.charAt(i) == '%');
                result.append(out.toString());
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static boolean isNative(URL url) {
        String name;
        File file = ClassLoaders.toFile(url);
        return file != null && !(name = file.getName()).endsWith(".jar") && !file.isDirectory() && name.contains(".so") && file.getAbsolutePath().startsWith("/usr/lib");
    }

    private static boolean isSurefire(ClassLoader classLoader) {
        return System.getProperty("surefire.real.class.path") != null && classLoader == SYSTEM;
    }

    private static Collection<URL> fromClassPath() {
        String[] cp = System.getProperty("java.class.path").split(System.getProperty("path.separator", ":"));
        HashSet<URL> urls = new HashSet<URL>();
        for (String path : cp) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urls;
    }

    public static Set<URL> findUrlFromResources(ClassLoader classLoader) throws IOException {
        HashSet<URL> set = new HashSet<URL>();
        for (URL url : Collections.list(classLoader.getResources("META-INF"))) {
            String externalForm = url.toExternalForm();
            set.add(new URL(externalForm.substring(0, externalForm.lastIndexOf("META-INF"))));
        }
        set.addAll(Collections.list(classLoader.getResources("")));
        return set;
    }

    private ClassLoaders() {
    }
}

