/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.deployer;

import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.Remote;
import jakarta.ejb.Singleton;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.ContextName;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.loader.TomcatHelper;

@Lock(value=LockType.READ)
@Singleton(name="openejb/WebappDeployer")
@Remote(value={Deployer.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class WebappDeployer
implements Deployer {
    private static final String WEBAPPS = "webapps";
    private static final String OPENEJB_HOME = "openejb.home";
    private final TomcatWebAppBuilder webappBuilder;
    private final Assembler assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);
    private final MBeanServer mBeanServer;

    public WebappDeployer() {
        this.webappBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public String getUniqueFile() {
        throw new TomEERuntimeException("This method is not used");
    }

    public Collection<AppInfo> getDeployedApps() {
        return this.assembler.getDeployedApplications();
    }

    public AppInfo deploy(String location) throws OpenEJBException {
        return this.deploy(location, null);
    }

    public AppInfo deploy(Properties properties) throws OpenEJBException {
        return this.deploy(null, properties);
    }

    public AppInfo deploy(String location, Properties properties) throws OpenEJBException {
        try {
            if (location == null && properties == null) {
                throw new NullPointerException("location and properties are null");
            }
            if (location == null) {
                location = properties.getProperty("filename");
            }
            File source = new File(location);
            File destination = new File(System.getProperty(OPENEJB_HOME) + File.separator + WEBAPPS + File.separator + source.getName());
            IO.copy((File)source, (File)destination);
            String destinationWithoutExtension = destination.getAbsolutePath();
            String destinationFilenameWithoutExtension = destination.getName();
            if (destination.getName().contains(".")) {
                destinationWithoutExtension = destinationWithoutExtension.substring(0, destinationWithoutExtension.lastIndexOf(46));
                destinationFilenameWithoutExtension = destinationFilenameWithoutExtension.substring(0, destinationFilenameWithoutExtension.lastIndexOf(46));
            }
            if (destination.getName().toLowerCase().endsWith(".war")) {
                this.checkWebapp(destinationFilenameWithoutExtension);
            } else {
                this.check();
            }
            AppInfo info = this.findAppInfo(destination.getAbsolutePath(), destinationWithoutExtension);
            if (info == null) {
                throw new NullPointerException("appinfo not found");
            }
            DeploymentExceptionManager dem = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class);
            if (dem.hasDeploymentFailed()) {
                Exception tre = dem.getLastException();
                dem.clearLastException(info);
                throw tre;
            }
            return info;
        }
        catch (Exception e) {
            throw new OpenEJBException((Throwable)e);
        }
    }

    private AppInfo findAppInfo(String ... paths) {
        Collection<AppInfo> deployedApps = this.getDeployedApps();
        for (AppInfo appInfo : deployedApps) {
            for (String path : paths) {
                if (!appInfo.path.equals(path)) continue;
                return appInfo;
            }
        }
        return null;
    }

    private void check() {
        StandardServer server = TomcatHelper.getServer();
        for (Service service : server.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            Engine engine = service.getContainer();
            for (Container engineChild : engine.findChildren()) {
                if (!(engineChild instanceof StandardHost)) continue;
                StandardHost host = (StandardHost)engineChild;
                this.webappBuilder.checkHost(host);
            }
        }
    }

    private void checkWebapp(String webappName) {
        try {
            ContextName cn = new ContextName(webappName, true);
            String name = "Catalina:type=Deployer,host=localhost";
            ObjectName oname = new ObjectName("Catalina:type=Deployer,host=localhost");
            Object[] params = new String[]{cn.getName()};
            String[] signature = new String[]{"java.lang.String"};
            this.mBeanServer.invoke(oname, "check", params, signature);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void undeploy(String moduleId) throws UndeployException, NoSuchApplicationException {
        try {
            AppInfo appInfo = this.findAppInfo(moduleId);
            if (appInfo != null) {
                this.webappBuilder.undeployWebApps(appInfo);
            }
            this.assembler.destroyApplication(moduleId);
            File moduleFile = new File(moduleId);
            if (moduleFile.getName().contains(".")) {
                File dir = new File(moduleFile.getAbsolutePath().substring(0, moduleFile.getAbsolutePath().lastIndexOf(46)));
                if (dir.exists() && dir.isDirectory()) {
                    this.delete(dir);
                }
            } else {
                this.delete(new File(moduleFile + ".war"));
                this.delete(new File(moduleFile + ".ear"));
                this.delete(new File(moduleFile + ".rar"));
            }
            this.delete(moduleFile);
        }
        catch (Exception e) {
            throw new UndeployException((Throwable)e);
        }
    }

    public void reload(String s) {
        throw new UnsupportedOperationException();
    }

    private void delete(File f) {
        if (f == null || !f.exists()) {
            return;
        }
        if (f.isFile()) {
            if (!f.delete()) {
                f.deleteOnExit();
            }
            return;
        }
        if (f.isDirectory()) {
            File[] listFiles = f.listFiles();
            if (listFiles != null) {
                for (File file : listFiles) {
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    this.delete(file);
                }
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }
}

