/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.tomee.server.composer.Archive;
import org.apache.tomee.server.composer.TomEE;
import org.tomitribe.util.PrintString;
import org.tomitribe.util.Strings;

public class Components
implements Consumer<TomEE.Builder> {
    private final List<Clazz> classes = new ArrayList<Clazz>();

    public Components(Clazz ... classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public static Components components(Clazz ... classes) {
        return new Components(classes);
    }

    public static Clazz of(Class<?> clazz) {
        return new Clazz(clazz);
    }

    @Override
    public void accept(TomEE.Builder builder) {
        Archive archive = Archive.archive();
        Properties properties = new Properties();
        for (Clazz clazz : this.classes) {
            archive.add(clazz.clazz);
            properties.put(clazz.prefix, "new://" + clazz.clazz.getName());
            for (Map.Entry<String, String> entry : clazz.map.entrySet()) {
                properties.put(clazz.prefix + "." + entry.getKey(), entry.getValue());
            }
        }
        PrintString out = new PrintString();
        try {
            properties.store((OutputStream)out, "Components");
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create trixie.properties", e);
        }
        builder.add("lib/components.jar", archive.asJar());
        builder.add("conf/trixie.properties", out.toString());
    }

    public static class Clazz
    implements Consumer<TomEE.Builder> {
        private final String prefix;
        private final Class clazz;
        private final Map<String, String> map = new HashMap<String, String>();

        public Clazz(Class clazz) {
            this(Strings.lcfirst((String)clazz.getSimpleName()), clazz);
        }

        public Clazz(String prefix, Class clazz) {
            this.prefix = prefix;
            this.clazz = clazz;
        }

        public Clazz with(String name, Object value) {
            this.map.put(name, "" + value);
            return this;
        }

        @Override
        public void accept(TomEE.Builder builder) {
            Components.components(this).accept(builder);
        }
    }
}

