/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;

public class Zips {
    private Zips() {
    }

    public static void unzip(File zipFile, File destination) throws IOException {
        Zips.unzip(zipFile, destination, false);
    }

    public static void unzip(File zipFile, File destination, boolean noparent) throws IOException {
        Zips.unzip(zipFile, destination, noparent, (File pathname) -> true);
    }

    public static void unzip(File zipFile, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Files.file((File)zipFile);
        Files.readable((File)zipFile);
        try (InputStream read = IO.read((File)zipFile);){
            Zips.unzip(read, destination, noparent, fileFilter);
        }
    }

    public static void unzip(InputStream read, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Objects.requireNonNull(fileFilter, "'fileFilter' is required.");
        Files.dir((File)destination);
        Files.writable((File)destination);
        try {
            ZipEntry entry;
            ZipInputStream e = new ZipInputStream(read);
            while ((entry = e.getNextEntry()) != null) {
                File file;
                String path = entry.getName();
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                if (!fileFilter.accept(file = new File(destination, path))) continue;
                if (entry.isDirectory()) {
                    Files.mkdir((File)file);
                    continue;
                }
                Files.mkdir((File)file.getParentFile());
                IO.copy((InputStream)e, (File)file);
                long lastModified = entry.getTime();
                if (lastModified <= 0L) continue;
                file.setLastModified(lastModified);
            }
            e.close();
        }
        catch (IOException var9) {
            throw new IOException("Unable to unzip " + read, var9);
        }
    }
}

