/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.tomee.server.composer.CleanOnExit;
import org.apache.tomee.server.composer.Excludes;
import org.apache.tomee.server.composer.Pipe;
import org.apache.tomee.server.composer.Ports;
import org.apache.tomee.server.composer.ServerBuilder;
import org.apache.tomee.server.composer.StartupFailedException;
import org.apache.tomee.server.composer.TarGzs;
import org.tomitribe.swizzle.stream.StreamBuilder;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;
import org.tomitribe.util.JarLocation;
import org.tomitribe.util.hash.XxHash64;

public class TomEE {
    private final Stats stats;
    private final File home;
    private final int port;
    private final Process process;
    private final CleanOnExit cleanOnExit;

    private TomEE(File home, int port, Process process, Stats stats, CleanOnExit cleanOnExit) {
        this.home = home;
        this.port = port;
        this.process = process;
        this.stats = stats;
        this.cleanOnExit = cleanOnExit;
    }

    public URI toURI() {
        return URI.create("http://localhost:" + this.port);
    }

    public File getHome() {
        return this.home;
    }

    public int getPort() {
        return this.port;
    }

    public Process getProcess() {
        return this.process;
    }

    public void shutdown() {
        try {
            this.process.destroy();
            this.process.waitFor();
            this.cleanOnExit.clean();
        }
        catch (Exception e) {
            throw new IllegalStateException("Shutdown failed", e);
        }
        if (this.home.exists()) {
            this.shutdown();
        }
    }

    public static Builder plus() throws Exception {
        return TomEE.of("org.apache.tomee:apache-tomee:tar.gz:plus:10.1.2");
    }

    public static Builder microprofile() throws Exception {
        return TomEE.of("org.apache.tomee:apache-tomee:tar.gz:microprofile:10.1.2");
    }

    public static Builder webprofile() throws Exception {
        return TomEE.of("org.apache.tomee:apache-tomee:tar.gz:webprofile:10.1.2");
    }

    public Stats getStats() {
        return this.stats;
    }

    public static Builder of(String mavenCoordinates) throws Exception {
        return new Builder(mavenCoordinates);
    }

    public static Builder from(File mavenCoordinates) throws Exception {
        return new Builder(mavenCoordinates);
    }

    private static boolean print(File file) {
        System.out.println(file.getAbsolutePath());
        return true;
    }

    public static class Stats {
        private final long extracted;
        private final long startup;

        public Stats(long extracted, long startup) {
            this.extracted = extracted;
            this.startup = startup;
        }

        public long getExtracted() {
            return this.extracted;
        }

        public long getStartup() {
            return this.startup;
        }
    }

    public static class Builder
    extends ServerBuilder<Builder> {
        private PrintStream err = System.err;
        private PrintStream out = System.out;

        public Builder(String mavenCoordinates) throws IOException {
            super(mavenCoordinates);
            this.filter(Excludes::webapps);
        }

        public Builder(File mavenCoordinates) throws IOException {
            super(mavenCoordinates);
            this.filter(Excludes::webapps);
        }

        public Builder err(PrintStream err) {
            this.err = err;
            return this;
        }

        public Builder out(PrintStream out) {
            this.out = out;
            return this;
        }

        public Builder update() {
            this.home(this::update);
            return this;
        }

        private void update(File home) {
            File repository = JarLocation.jarLocation(XxHash64.class).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            File org = Files.file((File)repository, (String[])new String[]{"org", "apache"});
            HashMap map = new HashMap();
            Files.collect((File)org, (String)".*\\.jar").stream().forEach(file -> map.put(file.getName(), file));
            File lib = new File(home, "lib");
            for (File jar : Files.collect((File)lib, (String)".*\\.jar")) {
                File file2 = (File)map.get(jar.getName());
                if (file2 == null || file2.lastModified() <= jar.lastModified()) continue;
                try {
                    System.out.printf("Updating %s%n", jar.getName());
                    IO.copy((File)file2, (File)jar);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        public Builder debug(int port, boolean suspend) {
            this.env("JPDA_ADDRESS", "" + port);
            this.env("JPDA_SUSPEND", suspend ? "y" : "n");
            return (Builder)this.debug();
        }

        public Builder debug(int port) {
            return this.debug(port, true);
        }

        public TomEE build() throws IOException {
            this.applyBuilderConsumers();
            CleanOnExit cleanOnExit = new CleanOnExit();
            File tmpdir = cleanOnExit.clean(Files.tmpdir());
            File home = new File(tmpdir, "server");
            Files.mkdir((File)home);
            long start = System.nanoTime();
            TarGzs.untargz(this.archive, home, true, this.filter);
            long extracted = System.nanoTime() - start;
            String os = System.getProperty("os.name").toLowerCase();
            String extension = ".sh";
            if (!os.contains("win")) {
                Stream.of(new File(home, "bin").listFiles()).filter((? super T file1) -> file1.getName().endsWith(".sh")).forEach(file2 -> file2.setExecutable(true));
            } else {
                extension = ".bat";
            }
            this.applyModifications(home);
            Iterator<Integer> ports = Ports.allocate(3).iterator();
            int http = ports.next();
            File serverxml = Files.file((File)home, (String[])new String[]{"conf", "server.xml"});
            String config = IO.slurp((File)serverxml).replace("8080", "" + http).replace("8005", "" + ports.next()).replace("8009", "" + ports.next());
            IO.copy((InputStream)IO.read((String)config), (File)serverxml);
            this.applyHomeConsumers(home);
            File catalinaSh = Files.file((File)home, (String[])new String[]{"bin", "catalina" + extension});
            ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(home);
            if (this.debug) {
                builder.command(catalinaSh.getAbsolutePath(), "jpda", "run");
            } else {
                builder.command(catalinaSh.getAbsolutePath(), "run");
            }
            if (this.env.containsKey("JAVA_OPTS")) {
                this.env.put("JAVA_OPTS", "-Duser.language=en -Duser.country=US " + (String)this.env.get("JAVA_OPTS"));
            } else {
                this.env.put("JAVA_OPTS", "-Duser.language=en -Duser.country=US");
            }
            if (!this.env.containsKey("JAVA_HOME")) {
                this.env.put("JAVA_HOME", System.getProperty("java.home"));
            }
            builder.environment().putAll(this.env);
            if (this.list) {
                Files.visit((File)tmpdir, TomEE::print);
            }
            long start2 = System.nanoTime();
            Process process = cleanOnExit.clean(builder.start());
            CountDownLatch startup = new CountDownLatch(1);
            StreamBuilder inputStream = StreamBuilder.create((InputStream)process.getInputStream());
            StreamBuilder errorStream = StreamBuilder.create((InputStream)process.getErrorStream()).watch("Server startup in ", startup::countDown);
            for (Consumer watch : this.watches) {
                watch.accept(inputStream);
            }
            for (Consumer watch : this.watches) {
                watch.accept(errorStream);
            }
            Future<Pipe> stout = Pipe.pipe(inputStream.get(), this.out);
            Future<Pipe> sterr = Pipe.pipe(errorStream.get(), this.err);
            try {
                if (!startup.await(this.await.getTime(), this.await.getUnit())) {
                    throw new StartupFailedException("Waited " + this.await.toString());
                }
            }
            catch (InterruptedException e) {
                throw new StartupFailedException(e);
            }
            long startTime = System.nanoTime() - start2;
            return new TomEE(home, http, process, new Stats(extracted, startTime), cleanOnExit);
        }
    }
}

