/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public final class Pipe
implements Runnable {
    private final InputStream in;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final OutputStream[] cc;

    public Pipe(InputStream in, OutputStream ... copy) {
        this.in = in;
        this.cc = copy;
    }

    public static Future<Pipe> pipe(InputStream in, OutputStream ... copy) {
        Pipe target = new Pipe(in, copy);
        FutureTask<Pipe> task = new FutureTask<Pipe>(target, target);
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    public synchronized String asString() {
        return new String(this.out.toByteArray());
    }

    @Override
    public synchronized void run() {
        try {
            int i = -1;
            while ((i = this.in.read()) != -1) {
                this.out.write(i);
                for (OutputStream stream : this.cc) {
                    stream.write(i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

