/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;

public class TarGzs {
    private TarGzs() {
    }

    public static void untargz(File zipFile, File destination) throws IOException {
        TarGzs.untargz(zipFile, destination, false);
    }

    public static void untargz(File zipFile, File destination, boolean noparent) throws IOException {
        TarGzs.untargz(zipFile, destination, noparent, (File pathname) -> true);
    }

    public static void untargz(File zipFile, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Files.file((File)zipFile);
        Files.readable((File)zipFile);
        try (InputStream read = IO.read((File)zipFile);){
            TarGzs.untargz(read, destination, noparent, fileFilter);
        }
    }

    public static void untargz(InputStream read, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Objects.requireNonNull(fileFilter, "'fileFilter' is required.");
        Files.dir((File)destination);
        Files.writable((File)destination);
        try {
            TarArchiveEntry entry;
            GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(read);
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);
            while ((entry = tarIn.getNextEntry()) != null) {
                File file;
                String path = entry.getName();
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                if (!fileFilter.accept(file = new File(destination, path))) continue;
                if (entry.isDirectory()) {
                    Files.mkdir((File)file);
                    continue;
                }
                Files.mkdir((File)file.getParentFile());
                IO.copy((InputStream)tarIn, (File)file);
                long lastModified = entry.getLastModifiedDate().getTime();
                if (lastModified > 0L) {
                    file.setLastModified(lastModified);
                }
                if (33261 == entry.getMode()) {
                    file.setExecutable(true);
                }
                if (493 != entry.getMode()) continue;
                file.setExecutable(true);
            }
            tarIn.close();
        }
        catch (IOException var9) {
            throw new IOException("Unable to unzip " + String.valueOf(read), var9);
        }
    }
}

