/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class CleanOnExit {
    private final List<File> files = new ArrayList<File>();
    private final List<Process> processes = new ArrayList<Process>();

    public CleanOnExit() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::clean));
    }

    public File clean(File file) {
        this.files.add(file);
        return file;
    }

    public Process clean(Process process) {
        this.processes.add(process);
        return process;
    }

    public void clean() {
        this.processes.stream().forEach(Process::destroy);
        for (Process process : this.processes) {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        this.files.stream().forEach(this::delete);
    }

    private void delete(File file) {
        try {
            Files.walkFileTree(file.toPath(), new RecursiveDelete());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class RecursiveDelete
    implements FileVisitor<Path> {
        private RecursiveDelete() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

