/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jdbc;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.sql.CommonDataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.openejb.cipher.PasswordCipherFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.resource.jdbc.dbcp.DataSourceSerialization;
import org.apache.openejb.resource.jdbc.pool.PoolDataSourceCreator;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import org.apache.xbean.recipe.ObjectRecipe;

public class TomEEDataSourceCreator
extends PoolDataSourceCreator {
    public javax.sql.DataSource pool(String name, javax.sql.DataSource ds, Properties properties) {
        ConnectionPool pool;
        PoolConfiguration config = (PoolConfiguration)this.build(TomEEPoolProperties.class, (Properties)this.createProperties(name, properties));
        config.setDataSource((Object)ds);
        try {
            pool = new ConnectionPool(config);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        TomEEDataSource dataSource = new TomEEDataSource(config, pool, name);
        this.recipes.put(dataSource, (ObjectRecipe)this.recipes.remove(config));
        return dataSource;
    }

    public CommonDataSource pool(String name, String driver, Properties properties) {
        PoolConfiguration config = (PoolConfiguration)this.build(TomEEPoolProperties.class, (Properties)this.createProperties(name, properties));
        TomEEDataSource ds = new TomEEDataSource(config, name);
        this.recipes.put(ds, (ObjectRecipe)this.recipes.remove(config));
        return ds;
    }

    protected void doDestroy(CommonDataSource dataSource) throws Throwable {
        DataSource ds = (DataSource)dataSource;
        if (ds instanceof TomEEDataSource) {
            ((TomEEDataSource)ds).internalJMXUnregister();
        }
        ds.close(true);
    }

    protected boolean trackRecipeFor(Object value) {
        return super.trackRecipeFor(value) || TomEEPoolProperties.class.isInstance(value);
    }

    private SuperProperties createProperties(String name, Properties properties) {
        SuperProperties converted = new SuperProperties(){

            public Object setProperty(String name, String value) {
                if (value == null) {
                    return super.getProperty(name);
                }
                return super.setProperty(name, value);
            }
        }.caseInsensitive(true);
        converted.setProperty("name", name);
        converted.setProperty("url", properties.getProperty("url", (String)properties.remove("JdbcUrl")));
        converted.setProperty("driverClassName", properties.getProperty("driverClassName", (String)properties.remove("JdbcDriver")));
        converted.setProperty("username", (String)properties.remove("username"));
        converted.setProperty("password", (String)properties.remove("password"));
        converted.putAll((Map)properties);
        String passwordCipher = (String)converted.remove((Object)"PasswordCipher");
        if (passwordCipher != null && !"PlainText".equals(passwordCipher)) {
            converted.setProperty("password", PasswordCipherFactory.getPasswordCipher((String)passwordCipher).decrypt(converted.getProperty("Password").toCharArray()));
        }
        return converted;
    }

    public static class TomEEPoolProperties
    extends PoolProperties {
        public void setMinEvictableIdleTime(String minEvictableIdleTime) {
            Duration duration = new Duration(minEvictableIdleTime);
            super.setMinEvictableIdleTimeMillis((int)duration.getUnit().toMillis(duration.getTime()));
        }

        public void setTimeBetweenEvictionRuns(String timeBetweenEvictionRuns) {
            Duration duration = new Duration(timeBetweenEvictionRuns);
            super.setMinEvictableIdleTimeMillis((int)duration.getUnit().toMillis(duration.getTime()));
        }

        public void setXaDataSource(String jndi) {
            try {
                this.setDataSource(((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext().lookup("openejb:Resource/" + jndi));
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }

        public void setDataSourceJNDI(String jndi) {
            super.setDataSourceJNDI("openejb:Resource/" + jndi);
        }
    }

    private static class TomEEConnectionPool
    extends ConnectionPool {
        private final ClassLoader creationLoader;

        public TomEEConnectionPool(PoolConfiguration poolProperties, ClassLoader creationLoader) throws SQLException {
            super(poolProperties);
            this.creationLoader = creationLoader;
        }

        protected PooledConnection create(boolean incrementCounter) {
            PooledConnection con = super.create(incrementCounter);
            if (this.getPoolProperties().getDataSource() == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = TomEEConnectionPool.class.getClassLoader();
                }
                try {
                    Reflections.set((Object)con, (String)"driver", Class.forName(this.getPoolProperties().getDriverClassName(), true, cl).newInstance());
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        Reflections.set((Object)con, (String)"driver", Class.forName(this.getPoolProperties().getDriverClassName(), true, this.creationLoader).newInstance());
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return con;
        }
    }

    private static class ReadOnlyConnectionpool
    implements InvocationHandler {
        private final PoolConfiguration delegate;

        public ReadOnlyConnectionpool(PoolConfiguration pool) {
            this.delegate = pool;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (!name.startsWith("set") || args == null || args.length != 1 || !Void.TYPE.equals(method.getReturnType())) {
                return method.invoke((Object)this.delegate, args);
            }
            if (name.equals("setDataSource")) {
                this.delegate.setDataSource(args[0]);
            }
            return null;
        }
    }

    public static class TomEEDataSource
    extends DataSource
    implements Serializable {
        private static final Log LOGGER = LogFactory.getLog(TomEEDataSource.class);
        private static final Class<?>[] CONNECTION_POOL_CLASS = new Class[]{PoolConfiguration.class};
        private final String name;
        private ObjectName internalOn;

        public TomEEDataSource(PoolConfiguration properties, ConnectionPool pool, String name) {
            super(TomEEDataSource.readOnly(properties));
            this.pool = pool;
            this.initJmx(name);
            this.name = name;
        }

        public TomEEDataSource(PoolConfiguration poolConfiguration, String name) {
            super(TomEEDataSource.readOnly(poolConfiguration));
            try {
                this.createPool();
                this.initJmx(name);
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Can't create DataSource", e);
            }
            this.name = name;
        }

        protected void registerJmx() {
        }

        protected void unregisterJmx() {
        }

        public ConnectionPool createPool() throws SQLException {
            if (this.pool != null) {
                return this.pool;
            }
            this.pool = new TomEEConnectionPool(this.poolProperties, Thread.currentThread().getContextClassLoader());
            return this.pool;
        }

        private static PoolConfiguration readOnly(PoolConfiguration pool) {
            try {
                return (PoolConfiguration)Proxy.newProxyInstance(TomEEDataSourceCreator.class.getClassLoader(), CONNECTION_POOL_CLASS, (InvocationHandler)new ReadOnlyConnectionpool(pool));
            }
            catch (Throwable e) {
                return (PoolConfiguration)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), CONNECTION_POOL_CLASS, (InvocationHandler)new ReadOnlyConnectionpool(pool));
            }
        }

        private void initJmx(String name) {
            try {
                this.internalOn = ObjectNameBuilder.uniqueName((String)"datasources", (String)name.replace("/", "_"), (Object)this);
                try {
                    if (this.pool.getJmxPool() != null) {
                        LocalMBeanServer.get().registerMBean(this.pool.getJmxPool(), this.internalOn);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unable to register JDBC pool with JMX", (Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void internalJMXUnregister() {
            if (this.internalOn != null) {
                try {
                    LocalMBeanServer.get().unregisterMBean(this.internalOn);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unable to unregister JDBC pool with JMX", (Throwable)e);
                }
            }
        }

        Object writeReplace() throws ObjectStreamException {
            return new DataSourceSerialization(this.name);
        }
    }
}

