/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.embedded.LoginConfigBuilder;
import org.apache.tomee.embedded.SecurityConstaintBuilder;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.recipe.ObjectRecipe;

public class Configuration {
    private int httpPort = 8080;
    private int stopPort = 8005;
    private String host = "localhost";
    protected String dir;
    private File serverXml;
    private boolean keepServerXmlAsThis;
    private Properties properties;
    private boolean quickSession = true;
    private boolean skipHttp;
    private int httpsPort = 8443;
    private boolean ssl;
    private boolean withEjbRemote;
    private String keystoreFile;
    private String keystorePass;
    private String keystoreType = "JKS";
    private String clientAuth;
    private String keyAlias;
    private String sslProtocol;
    private String webXml;
    private LoginConfigBuilder loginConfig;
    private Collection<SecurityConstaintBuilder> securityConstraints = new LinkedList<SecurityConstaintBuilder>();
    private Collection<String> customWebResources = new LinkedList<String>();
    private Realm realm;
    private boolean deployOpenEjbApp;
    private Map<String, String> users;
    private Map<String, String> roles;
    private boolean http2;
    private Filter classesFilter;
    private final Collection<Connector> connectors = new ArrayList<Connector>();
    private String tempDir = new File(System.getProperty("java.io.tmpdir"), "tomee-embedded_" + System.currentTimeMillis()).getAbsolutePath();
    private boolean webResourceCached = true;
    private String conf;
    private boolean deleteBaseOnStartup = true;

    public Configuration loadFrom(String resource) {
        Configuration configuration;
        block8: {
            InputStream is = this.findStream(resource);
            try {
                Properties config = IO.readProperties((InputStream)is, (Properties)new Properties());
                this.loadFromProperties(config);
                configuration = this;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            is.close();
        }
        return configuration;
    }

    private InputStream findStream(String resource) throws FileNotFoundException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            File file = new File(resource);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            throw new IllegalArgumentException("Didn't find: " + resource);
        }
        return stream;
    }

    public void loadFromProperties(final Properties config) {
        String conf;
        String classesFilterType;
        String customWebResources;
        String tempDir;
        String webXml;
        String sslProtocol;
        String keyAlias;
        String clientAuth;
        String keystoreType;
        String keystorePass;
        String keystoreFile;
        String deployOpenEjbApp;
        String withEjbRemote;
        String webResourceCached;
        String deleteBaseOnStartup;
        String http2;
        String ssl;
        String skipHttp;
        String quickSession;
        String keepServerXmlAsThis;
        String serverXml;
        String dir;
        String host;
        String stop;
        String https;
        StrSubstitutor strSubstitutor = new StrSubstitutor((StrLookup)new StrLookup<String>(){

            public String lookup(String key) {
                String property = System.getProperty(key);
                return property == null ? config.getProperty(key) : null;
            }
        });
        for (String key : config.stringPropertyNames()) {
            String newVal;
            String val = config.getProperty(key);
            if (val == null || val.trim().isEmpty() || val.equals(newVal = strSubstitutor.replace(config.getProperty(key)))) continue;
            config.setProperty(key, newVal);
        }
        String http = config.getProperty("http");
        if (http != null) {
            this.setHttpPort(Integer.parseInt(http));
        }
        if ((https = config.getProperty("https")) != null) {
            this.setHttpsPort(Integer.parseInt(https));
        }
        if ((stop = config.getProperty("stop")) != null) {
            this.setStopPort(Integer.parseInt(stop));
        }
        if ((host = config.getProperty("host")) != null) {
            this.setHost(host);
        }
        if ((dir = config.getProperty("dir")) != null) {
            this.setDir(dir);
        }
        if ((serverXml = config.getProperty("serverXml")) != null) {
            this.setServerXml(serverXml);
        }
        if ((keepServerXmlAsThis = config.getProperty("keepServerXmlAsThis")) != null) {
            this.setKeepServerXmlAsThis(Boolean.parseBoolean(keepServerXmlAsThis));
        }
        if ((quickSession = config.getProperty("quickSession")) != null) {
            this.setQuickSession(Boolean.parseBoolean(quickSession));
        }
        if ((skipHttp = config.getProperty("skipHttp")) != null) {
            this.setSkipHttp(Boolean.parseBoolean(skipHttp));
        }
        if ((ssl = config.getProperty("ssl")) != null) {
            this.setSsl(Boolean.parseBoolean(ssl));
        }
        if ((http2 = config.getProperty("http2")) != null) {
            this.setHttp2(Boolean.parseBoolean(http2));
        }
        if ((deleteBaseOnStartup = config.getProperty("deleteBaseOnStartup")) != null) {
            this.setDeleteBaseOnStartup(Boolean.parseBoolean(deleteBaseOnStartup));
        }
        if ((webResourceCached = config.getProperty("webResourceCached")) != null) {
            this.setWebResourceCached(Boolean.parseBoolean(webResourceCached));
        }
        if ((withEjbRemote = config.getProperty("withEjbRemote")) != null) {
            this.setWithEjbRemote(Boolean.parseBoolean(withEjbRemote));
        }
        if ((deployOpenEjbApp = config.getProperty("deployOpenEjbApp")) != null) {
            this.setDeployOpenEjbApp(Boolean.parseBoolean(deployOpenEjbApp));
        }
        if ((keystoreFile = config.getProperty("keystoreFile")) != null) {
            this.setKeystoreFile(keystoreFile);
        }
        if ((keystorePass = config.getProperty("keystorePass")) != null) {
            this.setKeystorePass(keystorePass);
        }
        if ((keystoreType = config.getProperty("keystoreType")) != null) {
            this.setKeystoreType(keystoreType);
        }
        if ((clientAuth = config.getProperty("clientAuth")) != null) {
            this.setClientAuth(clientAuth);
        }
        if ((keyAlias = config.getProperty("keyAlias")) != null) {
            this.setKeyAlias(keyAlias);
        }
        if ((sslProtocol = config.getProperty("sslProtocol")) != null) {
            this.setSslProtocol(sslProtocol);
        }
        if ((webXml = config.getProperty("webXml")) != null) {
            this.setWebXml(webXml);
        }
        if ((tempDir = config.getProperty("tempDir")) != null) {
            this.setTempDir(tempDir);
        }
        if ((customWebResources = config.getProperty("customWebResources")) != null) {
            this.setCustomWebResources(customWebResources);
        }
        if ((classesFilterType = config.getProperty("classesFilter")) != null) {
            try {
                this.setClassesFilter((Filter)Filter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(classesFilterType).newInstance()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if ((conf = config.getProperty("conf")) != null) {
            this.setConf(conf);
        }
        for (String prop : config.stringPropertyNames()) {
            String next;
            ObjectRecipe recipe;
            if (prop.startsWith("properties.")) {
                this.property(prop.substring("properties.".length()), config.getProperty(prop));
                continue;
            }
            if (prop.startsWith("users.")) {
                this.user(prop.substring("users.".length()), config.getProperty(prop));
                continue;
            }
            if (prop.startsWith("roles.")) {
                this.role(prop.substring("roles.".length()), config.getProperty(prop));
                continue;
            }
            if (prop.startsWith("connector.")) {
                this.property(prop, config.getProperty(prop));
                continue;
            }
            if (prop.equals("realm")) {
                recipe = new ObjectRecipe(config.getProperty(prop));
                for (String realmConfig : config.stringPropertyNames()) {
                    if (!realmConfig.startsWith("realm.")) continue;
                    recipe.setProperty(realmConfig.substring("realm.".length()), (Object)config.getProperty(realmConfig));
                }
                this.setRealm((Realm)Realm.class.cast(recipe.create()));
                continue;
            }
            if (prop.equals("login")) {
                recipe = new ObjectRecipe(LoginConfigBuilder.class.getName());
                for (String nestedConfig : config.stringPropertyNames()) {
                    if (!nestedConfig.startsWith("login.")) continue;
                    recipe.setProperty(nestedConfig.substring("login.".length()), (Object)config.getProperty(nestedConfig));
                }
                this.loginConfig((LoginConfigBuilder)LoginConfigBuilder.class.cast(recipe.create()));
                continue;
            }
            if (prop.equals("securityConstraint")) {
                recipe = new ObjectRecipe(SecurityConstaintBuilder.class.getName());
                for (String nestedConfig : config.stringPropertyNames()) {
                    if (!nestedConfig.startsWith("securityConstraint.")) continue;
                    recipe.setProperty(nestedConfig.substring("securityConstraint.".length()), (Object)config.getProperty(nestedConfig));
                }
                this.securityConstaint((SecurityConstaintBuilder)SecurityConstaintBuilder.class.cast(recipe.create()));
                continue;
            }
            if (!prop.equals("configurationCustomizer.") || (next = prop.substring("configurationCustomizer.".length())).contains(".")) continue;
            ObjectRecipe recipe2 = new ObjectRecipe(this.properties.getProperty(prop + ".class"));
            for (String nestedConfig : config.stringPropertyNames()) {
                if (!nestedConfig.startsWith(prop) || prop.endsWith(".class")) continue;
                recipe2.setProperty(nestedConfig.substring(prop.length() + 1), (Object)config.getProperty(nestedConfig));
            }
            this.addCustomizer((ConfigurationCustomizer)ConfigurationCustomizer.class.cast(recipe2.create()));
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public Configuration randomHttpPort() {
        this.httpPort = NetworkUtil.getNextAvailablePort();
        return this;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getDir() {
        return this.dir;
    }

    public Configuration dir(String dir) {
        this.setDir(dir);
        return this;
    }

    public boolean isWithEjbRemote() {
        return this.withEjbRemote;
    }

    public Configuration withEjbRemote(boolean withEjbRemote) {
        this.setWithEjbRemote(withEjbRemote);
        return this;
    }

    public void setWithEjbRemote(boolean withEjbRemote) {
        this.withEjbRemote = withEjbRemote;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setServerXml(String file) {
        if (file == null) {
            this.serverXml = null;
        } else {
            File sXml = new File(file);
            if (sXml.exists()) {
                this.serverXml = sXml;
            }
        }
    }

    public File getServerXmlFile() {
        return this.serverXml;
    }

    public boolean hasServerXml() {
        return this.serverXml != null && this.serverXml.exists();
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isQuickSession() {
        return this.quickSession;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSkipHttp() {
        return this.skipHttp;
    }

    public void setSkipHttp(boolean skipHttp) {
        this.skipHttp = skipHttp;
    }

    public void setQuickSession(boolean quickSession) {
        this.quickSession = quickSession;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public Configuration property(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
        return this;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public boolean isDeployOpenEjbApp() {
        return this.deployOpenEjbApp;
    }

    public void setDeployOpenEjbApp(boolean deployOpenEjbApp) {
        this.deployOpenEjbApp = deployOpenEjbApp;
    }

    public Configuration http(int port) {
        this.setHttpPort(port);
        return this;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, String> roles) {
        this.roles = roles;
    }

    public boolean isKeepServerXmlAsThis() {
        return this.keepServerXmlAsThis;
    }

    public void setKeepServerXmlAsThis(boolean keepServerXmlAsThis) {
        this.keepServerXmlAsThis = keepServerXmlAsThis;
    }

    public Configuration user(String name, String pwd) {
        if (this.users == null) {
            this.users = new HashMap<String, String>();
        }
        this.users.put(name, pwd);
        return this;
    }

    public Configuration role(String user, String roles) {
        if (this.roles == null) {
            this.roles = new HashMap<String, String>();
        }
        this.roles.put(user, roles);
        return this;
    }

    public Configuration setWebXml(String webXml) {
        this.webXml = webXml;
        return this;
    }

    public String getWebXml() {
        return this.webXml;
    }

    public LoginConfigBuilder getLoginConfig() {
        return this.loginConfig;
    }

    public Configuration loginConfig(LoginConfigBuilder loginConfig) {
        this.loginConfig = loginConfig;
        return this;
    }

    public Collection<SecurityConstaintBuilder> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public Configuration securityConstaint(SecurityConstaintBuilder constraint) {
        this.securityConstraints.add(constraint);
        return this;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public Configuration setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }

    public boolean areWebResourcesCached() {
        return this.webResourceCached;
    }

    public void setWebResourceCached(boolean cached) {
        this.webResourceCached = cached;
    }

    public boolean isHttp2() {
        return this.http2;
    }

    public void setHttp2(boolean http2) {
        this.http2 = http2;
    }

    public Collection<Connector> getConnectors() {
        return this.connectors;
    }

    public void addCustomizer(ConfigurationCustomizer configurationCustomizer) {
        configurationCustomizer.customize(this);
    }

    public Configuration conf(String config) {
        this.setConf(config);
        return this;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public void setClassesFilter(Filter filter) {
        this.classesFilter = filter;
    }

    public Configuration classesFilter(Filter filter) {
        this.setClassesFilter(filter);
        return this;
    }

    public Filter getClassesFilter() {
        return this.classesFilter;
    }

    public boolean isDeleteBaseOnStartup() {
        return this.deleteBaseOnStartup;
    }

    public void setDeleteBaseOnStartup(boolean deleteBaseOnStartup) {
        this.deleteBaseOnStartup = deleteBaseOnStartup;
    }

    public void setCustomWebResources(String web) {
        this.customWebResources.addAll(Arrays.asList(web.split(",")));
    }

    public void addCustomWebResources(String web) {
        this.customWebResources.add(web);
    }

    public Collection<String> getCustomWebResources() {
        return this.customWebResources;
    }

    public static interface ConfigurationCustomizer {
        public void customize(Configuration var1);
    }
}

