/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded.junit.jupiter;

import java.util.List;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.tomee.embedded.junit.TomEEEmbeddedBase;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;

public class TomEEEmbeddedExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final TomEEEmbeddedBase BASE = new TomEEEmbeddedBase();

    public void afterAll(ExtensionContext context) {
        if (this.isPerClass(context)) {
            BASE.close();
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (this.isPerClass(context)) {
            BASE.start(context.getRequiredTestInstance());
            this.doInject(context);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (!this.isPerClass(context)) {
            BASE.close();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (!this.isPerClass(context)) {
            BASE.start(context.getRequiredTestInstance());
            this.doInject(context);
        }
    }

    private void doInject(ExtensionContext extensionContext) {
        TestInstances oTestInstances = (TestInstances)extensionContext.getTestInstances().orElseThrow(() -> new OpenEJBRuntimeException("No test instances available for the given extension context."));
        List testInstances = oTestInstances.getAllInstances();
        testInstances.forEach(t -> {
            try {
                BASE.composerInject(t);
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException(e);
            }
        });
    }

    boolean isPerClass(ExtensionContext context) {
        return context.getTestInstanceLifecycle().map(it -> it.equals((Object)TestInstance.Lifecycle.PER_CLASS)).orElse(false);
    }
}

