/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tck.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.openejb.tck.OpenEJBTCKRuntimeException;
import org.apache.openejb.tck.util.ZipUtil;
import org.junit.Assert;

public class Archive {
    private final String name;
    private final InputStream in;

    public Archive(Iterable<URL> urls, Iterable<Class<?>> classes) {
        try {
            BufferedInputStream in;
            ClassLoader loader = Archive.class.getClassLoader();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            this.name = this.name(classes);
            for (Class<?> clazz : classes) {
                String name = clazz.getName().replace(".", "/") + ".class";
                URL resource = loader.getResource(name);
                if (resource == null) {
                    String path = clazz.getProtectionDomain().getCodeSource() + "!" + name;
                    try {
                        resource = new URL(path);
                    }
                    catch (MalformedURLException mue) {
                        Assert.fail((String)("can't find " + clazz.getName() + "neither from" + name + " nor from" + path));
                    }
                }
                Assert.assertNotNull((Object)resource);
                in = new BufferedInputStream(resource.openStream());
                out.putNextEntry(new ZipEntry(name));
                ZipUtil.copy(in, out);
                out.closeEntry();
            }
            for (URL url : urls) {
                String fileName = new File(url.getFile()).getName();
                String name = "META-INF/" + fileName;
                out.putNextEntry(new ZipEntry(name));
                in = new BufferedInputStream(url.openStream());
                ZipUtil.copy(in, out);
                ((InputStream)in).close();
            }
            out.close();
            this.in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            throw new OpenEJBTCKRuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public InputStream getIn() {
        return this.in;
    }

    private String name(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            if (clazz.getName().endsWith("AbstractJSR299Test") || !clazz.getName().endsWith("Test")) continue;
            return clazz.getName() + ".jar";
        }
        return "test-archive.jar";
    }
}

