/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import org.apache.bval.jsr.metadata.ValidatorMapping;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.reflection.TypeUtils;

public abstract class ValidatorMappingProvider {
    public final <A extends Annotation> ValidatorMapping<A> getValidatorMapping(Class<A> constraintType) {
        Optional<ValidatorMapping<A>> result = Optional.ofNullable(this.doGetValidatorMapping(constraintType));
        if (result.isPresent()) {
            for (Class<ConstraintValidator<A, ?>> t : result.get().getValidatorTypes()) {
                Type constraintParameter = TypeUtils.getTypeArguments(t, ConstraintValidator.class).get(ConstraintValidator.class.getTypeParameters()[0]);
                if (TypeUtils.isAssignable(constraintType, constraintParameter)) continue;
                Exceptions.raise(ConstraintDefinitionException::new, "%s %s expected first type parameter assignable from %s, %s; source %s", ConstraintValidator.class, t, constraintType, constraintParameter, result.get().getSource());
            }
            return result.get();
        }
        return null;
    }

    protected abstract <A extends Annotation> ValidatorMapping<A> doGetValidatorMapping(Class<A> var1);
}

