/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.groups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import javax.validation.metadata.GroupConversionDescriptor;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.Groups;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;

public class GroupsComputer {
    public static final Class<?>[] DEFAULT_GROUP = new Class[]{Default.class};
    public static final Groups DEFAULT_GROUPS = new Groups();
    private final Map<Class<?>, List<Group>> resolvedSequences = new ConcurrentHashMap();

    @SafeVarargs
    public final Groups computeGroups(Class<?> ... groups) {
        Exceptions.raiseIf(groups == null, IllegalArgumentException::new, "null validation groups specified", new Object[0]);
        if (groups.length == 0 || groups.length == 1 && groups[0] == Default.class) {
            return DEFAULT_GROUPS;
        }
        return this.computeGroups(Arrays.asList(groups));
    }

    @Deprecated
    public final Groups computeCascadingGroups(Set<GroupConversionDescriptor> groupConversions, Class<?> group) {
        Groups preliminaryResult = this.computeGroups(Stream.of(group));
        Map<Class, Class> gcMap = groupConversions.stream().collect(Collectors.toMap(GroupConversionDescriptor::getFrom, GroupConversionDescriptor::getTo));
        boolean simpleGroup = preliminaryResult.getSequences().isEmpty();
        if (simpleGroup && gcMap.containsKey(group)) {
            return this.computeGroups(Stream.of(gcMap.get(group)));
        }
        Groups result = new Groups();
        if (simpleGroup) {
            result.insertGroup(preliminaryResult.getGroups().iterator().next());
        } else {
            for (Group.Sequence seq : preliminaryResult.getSequences()) {
                ArrayList<Group> converted = new ArrayList<Group>();
                for (Group gg : seq.getGroups()) {
                    Class<?> c = gg.getGroup();
                    if (!gcMap.containsKey(c)) continue;
                    Groups convertedGroupExpansion = this.computeGroups(Stream.of(gcMap.get(c)));
                    if (convertedGroupExpansion.getSequences().isEmpty()) {
                        converted.add(gg);
                        continue;
                    }
                    convertedGroupExpansion.getSequences().stream().map(Group.Sequence::getGroups).flatMap(Collection::stream).forEach(converted::add);
                }
                result.insertSequence(converted);
            }
        }
        return result;
    }

    public Groups computeGroups(Collection<Class<?>> groups) {
        Validate.notNull(groups, "groups", new Object[0]);
        if (groups.isEmpty() || groups.size() == 1 && groups.contains(Default.class)) {
            return DEFAULT_GROUPS;
        }
        return this.computeGroups(groups.stream());
    }

    public Groups computeGroups(Stream<Class<?>> groups) {
        Groups result = new Groups();
        groups.peek(g -> {
            Exceptions.raiseIf(g == null, IllegalArgumentException::new, "Null group specified", new Object[0]);
            Exceptions.raiseUnless(g.isInterface(), ValidationException::new, "A group must be an interface. %s is not.", g);
        }).forEach(g -> {
            GroupSequence anno = g.getAnnotation(GroupSequence.class);
            if (anno == null) {
                result.insertGroup(new Group((Class<?>)g));
                this.insertInheritedGroups((Class<?>)g, result);
            } else {
                result.insertSequence(this.resolvedSequences.computeIfAbsent((Class<?>)g, gg -> this.resolveSequence((Class<?>)gg, anno, new HashSet())));
            }
        });
        if (Arrays.asList(DEFAULT_GROUP).equals(result.getGroups()) && result.getSequences().isEmpty()) {
            return DEFAULT_GROUPS;
        }
        return result;
    }

    private void insertInheritedGroups(Class<?> clazz, Groups chain) {
        for (Class<?> extendedInterface : clazz.getInterfaces()) {
            chain.insertGroup(new Group(extendedInterface));
            this.insertInheritedGroups(extendedInterface, chain);
        }
    }

    private List<Group> resolveSequence(Class<?> group, GroupSequence sequenceAnnotation, Set<Class<?>> processedSequences) {
        Exceptions.raiseUnless(processedSequences.add(group), GroupDefinitionException::new, "Cyclic dependency in groups definition", new Object[0]);
        ArrayList<Group> resolvedGroupSequence = new ArrayList<Group>();
        for (Class clazz : sequenceAnnotation.value()) {
            GroupSequence anno = clazz.getAnnotation(GroupSequence.class);
            if (anno == null) {
                resolvedGroupSequence.add(new Group(clazz));
                continue;
            }
            resolvedGroupSequence.addAll(this.resolveSequence(clazz, anno, processedSequences));
        }
        return resolvedGroupSequence;
    }

    static {
        for (Class<?> g : DEFAULT_GROUP) {
            DEFAULT_GROUPS.insertGroup(new Group(g));
        }
    }
}

