/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.validation.MessageInterpolator;
import org.apache.bval.el.MessageEvaluator;
import org.apache.bval.jsr.ApacheMessageContext;
import org.apache.bval.jsr.DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.util.LookBehindRegexHolder;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class DefaultMessageInterpolator
implements MessageInterpolator {
    private static final Logger log;
    private static final boolean LOG_FINEST;
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.apache.bval.jsr.ValidationMessages";
    private static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final LookBehindRegexHolder MESSAGE_PARAMETER;
    private static final ResourceBundle EMPTY_BUNDLE;
    private Locale defaultLocale;
    private final Map<Locale, ResourceBundle> userBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final Map<Locale, ResourceBundle> defaultBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final ConcurrentMap<ComputedMessageKey, String> interpolatedMessages = new ConcurrentHashMap<ComputedMessageKey, String>();
    private final ConcurrentMap<Class<?>, Method> toStringMethods = new ConcurrentHashMap();
    private final ConcurrentMap<MessageWithParamsKey, String> interpolations = new ConcurrentHashMap<MessageWithParamsKey, String>();
    private final MessageEvaluator evaluator;

    public DefaultMessageInterpolator() {
        this(null);
    }

    public DefaultMessageInterpolator(ResourceBundle resourceBundle) {
        MessageEvaluator ev;
        this.defaultLocale = Locale.getDefault();
        this.findDefaultResourceBundle(this.defaultLocale);
        if (resourceBundle == null) {
            this.findUserResourceBundle(this.defaultLocale);
        } else {
            this.userBundlesMap.put(this.defaultLocale, resourceBundle);
        }
        try {
            ev = (MessageEvaluator)MessageEvaluator.class.cast(this.getClass().getClassLoader().loadClass("org.apache.bval.el.ELFacade").getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable e) {
            ev = null;
        }
        this.evaluator = ev;
    }

    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolate(message, context, this.defaultLocale);
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        if (!message.contains("{")) {
            return this.resolveEscapeSequences(message);
        }
        String resolvedMessage = this.getSharedInterpolatedMessage(message, locale);
        Map annotationParameters = context.getConstraintDescriptor().getAttributes();
        resolvedMessage = this.replaceAnnotationAttributes(resolvedMessage, annotationParameters);
        if (this.evaluateExpressionLanguage(message, context)) {
            resolvedMessage = this.evaluator.interpolate(resolvedMessage, annotationParameters, context.getValidatedValue());
        }
        return this.resolveEscapeSequences(resolvedMessage);
    }

    private String getSharedInterpolatedMessage(String message, Locale locale) {
        ComputedMessageKey key = new ComputedMessageKey(locale, message);
        String value = (String)this.interpolatedMessages.get(key);
        if (value == null) {
            ResourceBundle userResourceBundle = this.findUserResourceBundle(locale);
            ResourceBundle defaultResourceBundle = this.findDefaultResourceBundle(locale);
            String resolvedMessage = message;
            boolean evaluatedDefaultBundleOnce = false;
            while (true) {
                String userBundleResolvedMessage = this.doReplaceVariables(resolvedMessage, userResourceBundle, locale, true);
                if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
                resolvedMessage = this.doReplaceVariables(userBundleResolvedMessage, defaultResourceBundle, locale, false);
                evaluatedDefaultBundleOnce = true;
            }
            value = resolvedMessage;
            this.interpolatedMessages.putIfAbsent(key, value);
        }
        return value;
    }

    private boolean evaluateExpressionLanguage(String template, MessageInterpolator.Context context) {
        if (this.evaluator != null) {
            if (Objects.equals(template, context.getConstraintDescriptor().getMessageTemplate())) {
                return true;
            }
            Optional<ApacheMessageContext> apacheMessageContext = Optional.of(context).map(ctx -> {
                try {
                    return (ApacheMessageContext)ctx.unwrap(ApacheMessageContext.class);
                }
                catch (Exception e) {
                    return null;
                }
            });
            return !apacheMessageContext.isPresent() || apacheMessageContext.map(amc -> amc.getConfigurationProperty("apache.bval.custom-template-expression-evaluation")).filter(Boolean::parseBoolean).isPresent();
        }
        return false;
    }

    private String resolveEscapeSequences(String s) {
        int pos = s.indexOf(92);
        if (pos < 0) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        int prev = 0;
        while (pos + 1 < s.length()) {
            if ("\\{}$".indexOf(s.charAt(pos + 1)) >= 0) {
                result.append(s, prev, pos);
                prev = pos + 1;
            }
            if ((pos = s.indexOf(92, pos + 2)) > 0) continue;
        }
        if (prev < s.length()) {
            result.append(s, prev, s.length());
        }
        return result.toString();
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private ResourceBundle getFileBasedResourceBundle(Locale locale) {
        ClassLoader classLoader = DefaultMessageInterpolator.org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(DefaultMessageInterpolator.class);
        ResourceBundle rb = this.loadBundle(classLoader, locale, USER_VALIDATION_MESSAGES);
        if (LOG_FINEST) {
            if (rb == null) {
                log.log(Level.FINEST, String.format("%s not found. Delegating to %s", USER_VALIDATION_MESSAGES, DEFAULT_VALIDATION_MESSAGES));
            } else {
                log.log(Level.FINEST, String.format("%s found", USER_VALIDATION_MESSAGES));
            }
        }
        return rb == null ? EMPTY_BUNDLE : rb;
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$0(Class clazz) {
        return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        return Optional.of(Thread.currentThread()).map(Thread::getContextClassLoader).orElseGet(() -> Validate.notNull(clazz).getClassLoader());
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        try {
            return ResourceBundle.getBundle(USER_VALIDATION_MESSAGES, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.fine(message);
            return null;
        }
    }

    private String doReplaceVariables(String message, ResourceBundle bundle, Locale locale, boolean recurse) {
        Matcher matcher = MESSAGE_PARAMETER.matcher(message);
        StringBuilder sb = new StringBuilder(64);
        int prev = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start > prev) {
                sb.append(message, prev, start);
            }
            sb.append(this.resolveParameter(matcher.group(1), bundle, locale, recurse).orElseGet(matcher::group));
            prev = matcher.end();
        }
        if (prev < message.length()) {
            sb.append(message, prev, message.length());
        }
        return sb.toString();
    }

    private String replaceAnnotationAttributes(String message, Map<String, Object> annotationParameters) {
        MessageWithParamsKey key = new MessageWithParamsKey(message, annotationParameters);
        String result = (String)this.interpolations.get(key);
        if (result == null) {
            Matcher matcher = MESSAGE_PARAMETER.matcher(message);
            if (!matcher.find()) {
                result = message;
            } else {
                StringBuilder sb = new StringBuilder(64);
                int prev = 0;
                do {
                    String resolvedParameterValue;
                    int start = matcher.start();
                    String parameter = matcher.group(1);
                    Object variable = annotationParameters.get(parameter);
                    if (variable == null) {
                        resolvedParameterValue = matcher.group();
                    } else if (Object[].class.isInstance(variable)) {
                        resolvedParameterValue = Arrays.toString((Object[])variable);
                    } else if (variable.getClass().isArray()) {
                        try {
                            resolvedParameterValue = (String)this.getToStringMethod(variable).invoke(null, variable);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new IllegalStateException("Could not expand array " + variable);
                        }
                    } else {
                        resolvedParameterValue = variable.toString();
                    }
                    if (start > prev) {
                        sb.append(message, prev, start);
                    }
                    sb.append(resolvedParameterValue);
                    prev = matcher.end();
                } while (matcher.find());
                if (prev < message.length()) {
                    sb.append(message, prev, message.length());
                }
                result = sb.toString();
            }
            this.interpolations.putIfAbsent(key, result);
        }
        return result;
    }

    public void clearCache() {
        this.interpolatedMessages.clear();
        this.interpolations.clear();
    }

    private Method getToStringMethod(Object variable) {
        Class<?> variableClass = variable.getClass();
        Method method = (Method)this.toStringMethods.get(variableClass);
        if (method == null) {
            method = DefaultMessageInterpolator.org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Arrays.class, "toString", new Class[]{variableClass});
            this.toStringMethods.putIfAbsent(variableClass, method);
        }
        return method;
    }

    @Privileged
    private static /* synthetic */ Method org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
        }
        return (Method)AccessController.doPrivileged(new DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION(clazz, string, classArray));
    }

    static /* synthetic */ Method __privileged_access$1(Class clazz, String string, Class[] classArray) {
        return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
    }

    private static /* synthetic */ Method __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Optional<String> resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recurse) {
        try {
            String string = bundle.getString(parameterName);
            return Optional.of(recurse ? this.doReplaceVariables(string, bundle, locale, recurse) : string);
        }
        catch (MissingResourceException e) {
            return Optional.empty();
        }
    }

    private ResourceBundle findDefaultResourceBundle(Locale locale) {
        return this.defaultBundlesMap.computeIfAbsent(locale, k -> ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, locale));
    }

    private ResourceBundle findUserResourceBundle(Locale locale) {
        return this.userBundlesMap.computeIfAbsent(locale, this::getFileBasedResourceBundle);
    }

    public void setLocale(Locale locale) {
        this.defaultLocale = locale;
        this.clearCache();
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(DefaultMessageInterpolator.class.getName());
        LOG_FINEST = log.isLoggable(Level.FINEST);
        MESSAGE_PARAMETER = new LookBehindRegexHolder("(?<!(?:^|[^\\\\])(?:\\\\\\\\){0,%1$d}\\\\)\\{((?:[\\w\\.]|\\\\[\\{\\$\\}\\\\])+)\\}", n -> (n - 4) / 2);
        EMPTY_BUNDLE = new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return null;
            }

            @Override
            public Enumeration<String> getKeys() {
                return Collections.emptyEnumeration();
            }
        };
    }

    static {
        DefaultMessageInterpolator.__privileged_clinit0();
    }

    private static class MessageWithParamsKey {
        private final String message;
        private final Map<String, Object> annotationParameters;
        private final int hash;

        private MessageWithParamsKey(String message, Map<String, Object> annotationParameters) {
            this.message = message;
            this.annotationParameters = annotationParameters;
            this.hash = Objects.hash(message, annotationParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageWithParamsKey that = (MessageWithParamsKey)MessageWithParamsKey.class.cast(o);
            return this.message.equals(that.message) && this.annotationParameters.equals(that.annotationParameters);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class ComputedMessageKey {
        private final Locale locale;
        private final String key;
        private final int hash;

        private ComputedMessageKey(Locale locale, String key) {
            this.locale = locale;
            this.key = key;
            this.hash = Objects.hash(locale, key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComputedMessageKey that = (ComputedMessageKey)ComputedMessageKey.class.cast(o);
            return this.locale.equals(that.locale) && this.key.equals(that.key);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

