/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.openejb.server.cli.CliRunnable;
import org.apache.openejb.server.ssh.OpenEJBJaasPasswordAuthenticator;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;

public class OpenEJBCommands
extends CliRunnable
implements Command,
Runnable,
ServerSessionAware {
    private ExitCallback cbk;
    private LoginContext loginContext;

    public OpenEJBCommands(String bind, int port) {
        super(bind, port, null, "\r\n");
    }

    public void setInputStream(InputStream in) {
        super.setInputStream(in);
    }

    public void setOutputStream(OutputStream out) {
        super.setOutputStream(out);
    }

    public void setErrorStream(OutputStream err) {
        super.setErrorStream(err);
    }

    public void destroy() {
        super.destroy();
    }

    public void setExitCallback(ExitCallback callback) {
        this.cbk = callback;
    }

    @Override
    public void run() {
        if (this.loginContext == null) {
            throw new IllegalStateException("No user logged");
        }
        try {
            Subject.doAs(this.loginContext.getSubject(), new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    OpenEJBCommands.super.run();
                    return null;
                }
            });
        }
        finally {
            try {
                this.loginContext.logout();
            }
            catch (LoginException loginException) {}
            this.cbk.onExit(0);
        }
    }

    public void setSession(ServerSession session) {
        String username = (String)session.getAttribute(OpenEJBJaasPasswordAuthenticator.USERNAME_KEY);
        if (username == null) {
            throw new IllegalStateException("No username in the session");
        }
        this.setUsername(username);
        this.loginContext = (LoginContext)session.getAttribute(OpenEJBJaasPasswordAuthenticator.LOGIN_CONTEXT_KEY);
    }

    public void start(ChannelSession channelSession, Environment environment) throws IOException {
        this.start();
    }

    public void destroy(ChannelSession channelSession) throws Exception {
        this.destroy();
    }
}

