/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit5;

import org.apache.openejb.junit5.ApplicationComposerPerXYExtensionBase;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ApplicationComposerPerAllExtension
extends ApplicationComposerPerXYExtensionBase
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB, ApplicationComposerPerAllExtension.class);

    public ApplicationComposerPerAllExtension() {
        this(null);
    }

    public ApplicationComposerPerAllExtension(Object ... modules) {
        super(modules);
    }

    @Override
    protected void validate(ExtensionContext context) {
        super.validate(context);
        if (this.isPerAll(context) && this.isPerMethodLifecycle(context)) {
            logger.info("Running PER_ALL in combination with TestInstance.Lifecycle.PER_METHOD.");
            logger.info("Please note, there are some limitations (N = amount of test methods):");
            logger.info("N = 1: Will work as expected.");
            logger.info("N > 1: Injections are lost after the first test method was executed.");
            logger.info("N > 1: Use CDI.current(), InitialContext or pure (http) client to implement the test.");
        }
    }

    @Override
    public void beforeAll(ExtensionContext context) throws Exception {
        super.beforeAll(context);
        this.doInit(context);
        this.doStart(context);
        this.doInject(context);
        this.addAfterAllReleaser(context);
    }
}

