/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.jee.transaction;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.apache.openejb.core.transaction.JtaTransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.junit.jee.transaction.Transaction;
import org.apache.openejb.loader.SystemInstance;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TransactionRule
implements TestRule {
    public Statement apply(final Statement base, Description description) {
        Method mtd = TransactionRule.getMethod(description.getTestClass(), description.getMethodName());
        final Transaction tx = mtd.getAnnotation(Transaction.class);
        if (tx != null) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    TransactionManager transactionManager = (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
                    JtaTransactionPolicyFactory factory = new JtaTransactionPolicyFactory(transactionManager);
                    TransactionPolicy policy = factory.createTransactionPolicy(TransactionType.RequiresNew);
                    try {
                        base.evaluate();
                    }
                    finally {
                        if (tx.rollback()) {
                            policy.setRollbackOnly();
                        }
                        policy.commit();
                    }
                }
            };
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
            }
        };
    }

    private static Method getMethod(Class<?> testClass, String methodName) {
        try {
            return testClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            for (Method mtd : testClass.getMethods()) {
                if (!methodName.equals(mtd.getName())) continue;
                return mtd;
            }
            return null;
        }
    }
}

