/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.jee.statement;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import org.apache.openejb.Injector;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.junit.jee.resources.TestResource;
import org.apache.openejb.junit.jee.statement.StartingStatement;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.testing.TestInstance;
import org.junit.runners.model.Statement;

public class InjectStatement
extends Statement {
    private final StartingStatement startingStatement;
    private final Object test;
    private final Statement statement;
    private final Class<?> clazz;

    public InjectStatement(Statement stat, Class<?> clazz, Object o, StartingStatement startingStatement) {
        this.statement = stat;
        this.clazz = clazz;
        this.test = o;
        this.startingStatement = startingStatement;
    }

    public void evaluate() throws Throwable {
        if (this.startingStatement != null) {
            Class<?> clazz = this.clazz;
            while (!Object.class.equals(clazz)) {
                for (Field field : clazz.getDeclaredFields()) {
                    TestResource resource = field.getAnnotation(TestResource.class);
                    if (resource == null) continue;
                    if (Context.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        field.set(Modifier.isStatic(field.getModifiers()) ? null : this.test, this.startingStatement.getContainer().getContext());
                        continue;
                    }
                    if (Hashtable.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        field.set(Modifier.isStatic(field.getModifiers()) ? null : this.test, this.startingStatement.getProperties());
                        continue;
                    }
                    if (EJBContainer.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        field.set(Modifier.isStatic(field.getModifiers()) ? null : this.test, this.startingStatement.getContainer());
                        continue;
                    }
                    throw new OpenEJBException("can't inject field '" + field.getName() + "'");
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (this.test != null) {
            SystemInstance.get().setComponent(TestInstance.class, (Object)new TestInstance(this.test.getClass(), this.test));
            SystemInstance.get().getComponent(FallbackPropertyInjector.class);
            Injector.inject((Object)this.test);
        }
        if (this.statement != null) {
            this.statement.evaluate();
        }
    }
}

