/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBAccessException;
import org.apache.openejb.junit.OpenEjbRunner;
import org.apache.openejb.junit.TestSecurity;
import org.apache.openejb.junit.context.ContextWrapperStatement;
import org.apache.openejb.junit.context.TestContext;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnit4Runner
extends BlockJUnit4ClassRunner {
    private final OpenEjbRunner runner;

    public JUnit4Runner(OpenEjbRunner runner, Class<?> testClazz) throws InitializationError {
        super(testClazz);
        this.runner = runner;
    }

    protected OpenEjbRunner getOpenEjbRunner() {
        return this.runner;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        TestSecurity testSecurity = null;
        if (method.getMethod().isAnnotationPresent(TestSecurity.class)) {
            testSecurity = method.getMethod().getAnnotation(TestSecurity.class);
        } else if (this.getTestClass().getJavaClass().isAnnotationPresent(TestSecurity.class)) {
            testSecurity = this.getTestClass().getJavaClass().getAnnotation(TestSecurity.class);
        }
        if (testSecurity == null || testSecurity.authorized().length == 0 && testSecurity.unauthorized().length == 0) {
            return this.createUnsecuredStatement(method);
        }
        return this.createSecuredStatementExecutor(method, testSecurity);
    }

    protected Statement createUnsecuredStatement(FrameworkMethod method) {
        Object test = this.newTestInstance();
        Statement statement = this.methodInvoker(method, test);
        statement = this.possiblyExpectingExceptions(method, test, statement);
        statement = this.withPotentialTimeout(method, test, statement);
        statement = this.withBefores(method, test, statement);
        statement = this.withAfters(method, test, statement);
        TestContext context = this.runner.newTestContext(method.getMethod());
        return new ContextWrapperStatement(context, statement, test);
    }

    private Statement createSecuredStatementExecutor(FrameworkMethod method, TestSecurity testSecurity) {
        Statement statement;
        MultiStatementExecutor statementExecutor = new MultiStatementExecutor();
        for (String role : testSecurity.authorized()) {
            statement = this.createSecuredStatement(method, role, false);
            statementExecutor.addStatement(statement);
        }
        for (String role : testSecurity.unauthorized()) {
            statement = this.createSecuredStatement(method, role, true);
            statementExecutor.addStatement(statement);
        }
        return statementExecutor;
    }

    private Statement createSecuredStatement(FrameworkMethod method, String role, boolean failWithAccessException) {
        Object test = this.newTestInstance();
        Statement statement = this.methodInvoker(method, test);
        statement = this.possiblyExpectingAccessException(statement, failWithAccessException);
        statement = this.possiblyExpectingExceptions(method, test, statement);
        statement = this.withPotentialTimeout(method, test, statement);
        statement = this.withBefores(method, test, statement);
        statement = this.withAfters(method, test, statement);
        TestContext context = this.runner.newTestContext(method.getMethod(), role);
        return new ContextWrapperStatement(context, statement, test);
    }

    protected Statement possiblyExpectingAccessException(Statement next, boolean failWithAccessException) {
        if (failWithAccessException) {
            return new ExpectException(next, EJBAccessException.class);
        }
        return next;
    }

    private Object newTestInstance() {
        try {
            return new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return JUnit4Runner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
    }

    public static class MultiStatementExecutor
    extends Statement {
        private final List<Statement> statements = new ArrayList<Statement>();

        public void evaluate() throws Throwable {
            for (Statement statement : this.statements) {
                statement.evaluate();
            }
        }

        public void addStatement(Statement statement) {
            this.statements.add(statement);
        }
    }
}

